/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;

public class Template
implements Serializable {
    private int id;
    private String name;
    private boolean isDirectAligned;
    private Map<String, IMeasurementSchema> schemaMap = new HashMap<String, IMeasurementSchema>();
    private transient Map<String, IMNode> directNodes;
    private transient int rehashCode;

    public Template() {
        this.directNodes = new HashMap<String, IMNode>();
    }

    public Template(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors) throws IllegalPathException {
        this(name, measurements, dataTypes, encodings, compressors, null);
    }

    public Template(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors, Set<String> alignedDeviceId) throws IllegalPathException {
        this.name = name;
        this.isDirectAligned = false;
        this.directNodes = new HashMap<String, IMNode>();
        this.rehashCode = 0;
        for (int i = 0; i < measurements.size(); ++i) {
            boolean isAlign;
            int size = measurements.get(i).size();
            if (size > 1) {
                isAlign = true;
            } else {
                String[] thisMeasurement = PathUtils.splitPathToDetachedNodes((String)measurements.get(i).get(0));
                String thisPrefix = Template.joinBySeparator(Arrays.copyOf(thisMeasurement, thisMeasurement.length - 1));
                boolean bl = isAlign = alignedDeviceId != null && alignedDeviceId.contains(thisPrefix);
            }
            if (isAlign) {
                String[] measurementsArray = new String[size];
                TSDataType[] typeArray = new TSDataType[size];
                TSEncoding[] encodingArray = new TSEncoding[size];
                CompressionType[] compressorArray = new CompressionType[size];
                for (int j = 0; j < size; ++j) {
                    measurementsArray[j] = measurements.get(i).get(j);
                    typeArray[j] = dataTypes.get(i).get(j);
                    encodingArray[j] = encodings.get(i).get(j);
                    compressorArray[j] = compressors.get(i).get(j);
                }
                IMeasurementSchema[] curSchemas = this.constructSchemas(measurementsArray, typeArray, encodingArray, compressorArray);
                this.constructTemplateTree(measurementsArray, curSchemas);
                continue;
            }
            MeasurementSchema curSchema = new MeasurementSchema(measurements.get(i).get(0), dataTypes.get(i).get(0), encodings.get(i).get(0), compressors.get(i).get(0));
            this.constructTemplateTree(measurements.get(i).get(0), (IMeasurementSchema)curSchema);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, IMeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public boolean hasSchema(String suffixPath) {
        return this.schemaMap.containsKey(suffixPath);
    }

    public IMeasurementSchema getSchema(String measurementId) {
        return this.schemaMap.get(measurementId);
    }

    public boolean isDirectAligned() {
        return this.isDirectAligned;
    }

    public int getMeasurementNumber() {
        return this.schemaMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTemplateTree(String[] alignedPaths, IMeasurementSchema[] schemas) throws IllegalPathException {
        String prefix = null;
        ArrayList<String> measurementNames = new ArrayList<String>();
        HashSet<String> pathSet = new HashSet<String>(Arrays.asList(alignedPaths));
        if (pathSet.size() != alignedPaths.length) {
            throw new IllegalPathException("Duplication in paths.");
        }
        HashSet<String> checkSet = new HashSet<String>();
        for (String path : alignedPaths) {
            if (this.getPathNodeInTemplate(path) != null) {
                throw new IllegalPathException("Path duplicated: " + path);
            }
            String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
            prefix = pathNodes.length == 1 ? "" : Template.joinBySeparator(Arrays.copyOf(pathNodes, pathNodes.length - 1));
            if (checkSet.isEmpty()) {
                checkSet.add(prefix);
            }
            if (!checkSet.contains(prefix)) {
                throw new IllegalPathException("Aligned measurements get different paths, " + alignedPaths[0]);
            }
            measurementNames.add(pathNodes[pathNodes.length - 1]);
        }
        Template template = this;
        synchronized (template) {
            if (prefix.equals("")) {
                this.isDirectAligned = true;
            }
            for (int i = 0; i <= measurementNames.size() - 1; ++i) {
                IMeasurementMNode leafNode;
                if ("".equals(prefix)) {
                    leafNode = MeasurementMNode.getMeasurementMNode(null, (String)measurementNames.get(i), schemas[i], null);
                    this.directNodes.put(leafNode.getName(), leafNode);
                } else {
                    IMNode commonPar = this.constructEntityPath(alignedPaths[0]);
                    commonPar.getAsEntityMNode().setAligned(true);
                    leafNode = MeasurementMNode.getMeasurementMNode(commonPar.getAsEntityMNode(), (String)measurementNames.get(i), schemas[i], null);
                    commonPar.addChild(leafNode);
                }
                this.schemaMap.put(this.getFullPathWithoutTemplateName(leafNode), schemas[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMeasurementMNode constructTemplateTree(String path, IMeasurementSchema schema) throws IllegalPathException {
        if (this.getPathNodeInTemplate(path) != null) {
            throw new IllegalPathException("Path duplicated: " + path);
        }
        String[] pathNode = PathUtils.splitPathToDetachedNodes((String)path);
        IMNode cur = this.constructEntityPath(path);
        Template template = this;
        synchronized (template) {
            IMeasurementMNode leafNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)cur, pathNode[pathNode.length - 1], schema, null);
            if (cur == null) {
                this.directNodes.put(leafNode.getName(), leafNode);
            } else {
                cur.addChild(leafNode);
            }
            this.schemaMap.put(this.getFullPathWithoutTemplateName(leafNode), schema);
            return leafNode;
        }
    }

    private IMeasurementSchema constructSchema(String nodeName, TSDataType dataType, TSEncoding encoding, CompressionType compressor) {
        return new MeasurementSchema(nodeName, dataType, encoding, compressor);
    }

    private IMeasurementSchema[] constructSchemas(String[] nodeNames, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        MeasurementSchema[] schemas = new MeasurementSchema[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            schemas[i] = new MeasurementSchema(new PartialPath(nodeNames[i]).getMeasurement(), dataTypes[i], encodings[i], compressors[i]);
        }
        return schemas;
    }

    public IMNode getPathNodeInTemplate(String path) throws IllegalPathException {
        return this.getPathNodeInTemplate(PathUtils.splitPathToDetachedNodes((String)path));
    }

    private IMNode getPathNodeInTemplate(String[] pathNodes) {
        if (pathNodes.length == 0) {
            return null;
        }
        IMNode cur = this.directNodes.getOrDefault(pathNodes[0], null);
        if (cur == null || cur.isMeasurement()) {
            return cur;
        }
        for (int i = 1; i < pathNodes.length; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                return null;
            }
            cur = cur.getChild(pathNodes[i]);
        }
        return cur;
    }

    public IMNode getDirectNode(String nodeName) {
        return this.directNodes.getOrDefault(nodeName, null);
    }

    public Collection<IMNode> getDirectNodes() {
        return this.directNodes.values();
    }

    private String getFullPathWithoutTemplateName(IMNode node) {
        if (node == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(node.getName());
        for (IMNode cur = node.getParent(); cur != null; cur = cur.getParent()) {
            builder.insert(0, cur.getName() + ".");
        }
        return builder.toString();
    }

    private IMNode constructEntityPath(String path) throws IllegalPathException {
        String[] pathNodes = PathUtils.splitPathToDetachedNodes((String)path);
        if (pathNodes.length == 1) {
            return null;
        }
        IMNode cur = this.directNodes.get(pathNodes[0]);
        if (cur == null) {
            cur = new EntityMNode(null, pathNodes[0]);
            this.directNodes.put(pathNodes[0], cur);
        }
        if (cur.isMeasurement()) {
            throw new IllegalPathException(path, "there is measurement in path.");
        }
        for (int i = 1; i <= pathNodes.length - 2; ++i) {
            if (!cur.hasChild(pathNodes[i])) {
                cur.addChild(pathNodes[i], new EntityMNode(cur, pathNodes[i]));
            }
            if (!(cur = cur.getChild(pathNodes[i])).isMeasurement()) continue;
            throw new IllegalPathException(path, "there is measurement in path.");
        }
        return cur;
    }

    private static String joinBySeparator(String[] pathNodes) {
        if (pathNodes == null || pathNodes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(pathNodes[0]);
        for (int i = 1; i <= pathNodes.length - 1; ++i) {
            builder.append(".");
            builder.append(pathNodes[i]);
        }
        return builder.toString();
    }

    public void addAlignedMeasurements(String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        String[] leafNodes = new String[measurements.length];
        String[] pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[0]);
        String prefix = Template.joinBySeparator(Arrays.copyOf(pathNode, pathNode.length - 1));
        IMNode targetNode = this.getPathNodeInTemplate(prefix);
        if (targetNode != null && !targetNode.getAsEntityMNode().isAligned() || prefix.equals("") && !this.isDirectAligned()) {
            throw new IllegalPathException(prefix, "path already exists but not aligned");
        }
        for (int i = 0; i <= measurements.length - 1; ++i) {
            pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[i]);
            leafNodes[i] = pathNode[pathNode.length - 1];
        }
        IMeasurementSchema[] schema = this.constructSchemas(leafNodes, dataTypes, encodings, compressors);
        this.constructTemplateTree(measurements, schema);
    }

    public void addUnalignedMeasurements(String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) throws IllegalPathException {
        HashSet<String> pathSet = new HashSet<String>(Arrays.asList(measurements));
        if (pathSet.size() != measurements.length) {
            throw new IllegalPathException("Duplication in paths.");
        }
        for (int i = 0; i <= measurements.length - 1; ++i) {
            String[] pathNode = PathUtils.splitPathToDetachedNodes((String)measurements[i]);
            String prefix = Template.joinBySeparator(Arrays.copyOf(pathNode, pathNode.length - 1));
            IMNode parNode = this.getPathNodeInTemplate(prefix);
            if (parNode != null && parNode.getAsEntityMNode().isAligned() || prefix.equals("") && this.isDirectAligned()) {
                throw new IllegalPathException(measurements[i], "path already exists and aligned");
            }
            IMeasurementSchema schema = this.constructSchema(pathNode[pathNode.length - 1], dataTypes[i], encodings[i], compressors[i]);
            this.constructTemplateTree(measurements[i], schema);
        }
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.id, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isDirectAligned, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.schemaMap.size(), (ByteBuffer)buffer);
        for (Map.Entry<String, IMeasurementSchema> entry : this.schemaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)buffer);
            entry.getValue().partialSerializeTo(buffer);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.id, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isDirectAligned, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.schemaMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, IMeasurementSchema> entry : this.schemaMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            entry.getValue().partialSerializeTo(outputStream);
        }
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.id = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.isDirectAligned = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        int schemaSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.schemaMap = new HashMap<String, IMeasurementSchema>(schemaSize);
        this.directNodes = new HashMap<String, IMNode>(schemaSize);
        for (int i = 0; i < schemaSize; ++i) {
            String schemaName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            byte flag = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            MeasurementSchema measurementSchema = null;
            if (flag == 0) {
                measurementSchema = MeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            } else if (flag == 1) {
                measurementSchema = VectorMeasurementSchema.partialDeserializeFrom((ByteBuffer)buffer);
            }
            this.schemaMap.put(schemaName, (IMeasurementSchema)measurementSchema);
            this.directNodes.put(schemaName, new MeasurementMNode(null, schemaName, (IMeasurementSchema)measurementSchema, null));
        }
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (t == null || this.getClass() != t.getClass()) {
            return false;
        }
        Template that = (Template)t;
        return this.name.equals(that.name) && this.schemaMap.equals(that.schemaMap);
    }

    public int hashCode() {
        return this.rehashCode != 0 ? this.rehashCode : new HashCodeBuilder(17, 37).append((Object)this.name).append(this.schemaMap).toHashCode();
    }
}

