/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumn;
import org.apache.iotdb.tsfile.read.common.block.column.LongColumnBuilder;

public class LongLinearFill
extends LinearFill {
    private long previousValue;
    private long nextValue;
    private long nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((long[])array)[index] = column.getLong(index);
    }

    @Override
    void fillValue(Object array, int index) {
        ((long[])array)[index] = this.getFilledValue();
    }

    @Override
    Object createValueArray(int size) {
        return new long[size];
    }

    @Override
    Column createNullValueColumn() {
        return LongColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn() {
        long filledValue = this.getFilledValue();
        return new LongColumn(1, Optional.empty(), new long[]{filledValue});
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new LongColumn(size, Optional.of(isNull), (long[])array);
        }
        return new LongColumn(size, Optional.empty(), (long[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getLong(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getLong(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getLong(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private long getFilledValue() {
        return (this.previousValue + this.nextValueInCurrentColumn) / 2L;
    }
}

