/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemUtils {
    private static Logger logger = LoggerFactory.getLogger(MemUtils.class);

    private MemUtils() {
    }

    public static long getRecordSize(TSDataType dataType, Object value, boolean addingTextDataSize) {
        if (dataType == TSDataType.TEXT) {
            return 8L + (addingTextDataSize ? MemUtils.getBinarySize((Binary)value) : 0L);
        }
        return 8L + (long)dataType.getDataTypeSize();
    }

    public static long getRecordsSize(List<TSDataType> dataTypes, Object[] value, boolean addingTextDataSize) {
        int emptyRecordCount = 0;
        long memSize = 0L;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                ++emptyRecordCount;
                continue;
            }
            memSize += MemUtils.getRecordSize(dataTypes.get(i - emptyRecordCount), value[i], addingTextDataSize);
        }
        return memSize;
    }

    public static long getAlignedRecordsSize(List<TSDataType> dataTypes, Object[] value, boolean addingTextDataSize) {
        long memSize = 12L;
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (value[i] == null) continue;
            if (dataTypes.get(i) == TSDataType.TEXT) {
                memSize += addingTextDataSize ? MemUtils.getBinarySize((Binary)value[i]) : 0L;
                continue;
            }
            memSize += (long)dataTypes.get(i).getDataTypeSize();
        }
        return memSize;
    }

    public static long getBinarySize(Binary value) {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf((byte[])value.getValues());
    }

    public static long getBinaryColumnSize(Binary[] column, int start, int end) {
        long memSize = 0L;
        memSize += (long)((end - start) * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER);
        for (int i = start; i < end; ++i) {
            memSize += RamUsageEstimator.sizeOf((byte[])column[i].getValues());
        }
        return memSize;
    }

    public static long getTabletSize(InsertTabletNode insertTabletNode, int start, int end, boolean addingTextDataSize) {
        if (start >= end) {
            return 0L;
        }
        long memSize = 0L;
        for (int i = 0; i < insertTabletNode.getMeasurements().length; ++i) {
            if (insertTabletNode.getMeasurements()[i] == null) continue;
            memSize += (long)(end - start) * 8L;
            if (insertTabletNode.getDataTypes()[i] == TSDataType.TEXT && addingTextDataSize) {
                for (int j = start; j < end; ++j) {
                    memSize += MemUtils.getBinarySize(((Binary[])insertTabletNode.getColumns()[i])[j]);
                }
                continue;
            }
            memSize += (long)((end - start) * insertTabletNode.getDataTypes()[i].getDataTypeSize());
        }
        return memSize;
    }

    public static long getAlignedTabletSize(InsertTabletNode insertTabletNode, int start, int end, boolean addingTextDataSize) {
        if (start >= end) {
            return 0L;
        }
        long memSize = 0L;
        for (int i = 0; i < insertTabletNode.getMeasurements().length; ++i) {
            if (insertTabletNode.getMeasurements()[i] == null) continue;
            TSDataType valueType = insertTabletNode.getDataTypes()[i];
            if (valueType == TSDataType.TEXT && addingTextDataSize) {
                for (int j = start; j < end; ++j) {
                    memSize += MemUtils.getBinarySize(((Binary[])insertTabletNode.getColumns()[i])[j]);
                }
                continue;
            }
            memSize += (long)(end - start) * (long)valueType.getDataTypeSize();
        }
        return memSize += (long)(end - start) * 12L;
    }

    public static long getTsRecordMem(TSRecord record) {
        long memUsed = 8L;
        memUsed += 8L;
        memUsed += MemUtils.getStringMem(record.deviceId);
        for (DataPoint dataPoint : record.dataPointList) {
            memUsed += 8L;
            memUsed += MemUtils.getDataPointMem(dataPoint);
        }
        return memUsed;
    }

    public static long getStringMem(String str) {
        return (long)(str.length() * 2) + 64L;
    }

    public static long getDataPointMem(DataPoint dataPoint) {
        long memUsed = 8L;
        memUsed += MemUtils.getStringMem(dataPoint.getMeasurementId());
        memUsed += 8L;
        if (dataPoint instanceof FloatDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof IntDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof BooleanDataPoint) {
            ++memUsed;
        } else if (dataPoint instanceof DoubleDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof LongDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof StringDataPoint) {
            StringDataPoint stringDataPoint = (StringDataPoint)dataPoint;
            memUsed += 28L;
            memUsed += (long)((Binary)stringDataPoint.getValue()).getLength();
            memUsed += 8L;
            memUsed += MemUtils.getStringMem(((Binary)stringDataPoint.getValue()).getTextEncodingType());
        } else {
            logger.error("Unsupported data point type");
        }
        return memUsed;
    }

    public static String bytesCntToStr(long inputCnt) {
        long cnt = inputCnt;
        long gbs = cnt / 0x40000000L;
        long mbs = (cnt %= 0x40000000L) / 0x100000L;
        long kbs = (cnt %= 0x100000L) / 1024L;
        return gbs + " GB " + mbs + " MB " + kbs + " KB " + (cnt %= 1024L) + " B";
    }
}

