/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories;

import java.util.List;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy;
import org.apache.iotdb.db.conf.directories.strategy.MinFolderOccupiedSpaceFirstStrategy;
import org.apache.iotdb.db.conf.directories.strategy.RandomOnDiskUsableSpaceStrategy;
import org.apache.iotdb.db.conf.directories.strategy.SequenceStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderManager {
    private static final Logger logger = LoggerFactory.getLogger(FolderManager.class);
    private final List<String> folders;
    private final DirectoryStrategy selectStrategy;

    public FolderManager(List<String> folders, DirectoryStrategyType type) throws DiskSpaceInsufficientException {
        this.folders = folders;
        switch (type) {
            case SEQUENCE_STRATEGY: {
                this.selectStrategy = new SequenceStrategy();
                break;
            }
            case MAX_DISK_USABLE_SPACE_FIRST_STRATEGY: {
                this.selectStrategy = new MaxDiskUsableSpaceFirstStrategy();
                break;
            }
            case MIN_FOLDER_OCCUPIED_SPACE_FIRST_STRATEGY: {
                this.selectStrategy = new MinFolderOccupiedSpaceFirstStrategy();
                break;
            }
            case RANDOM_ON_DISK_USABLE_SPACE_STRATEGY: {
                this.selectStrategy = new RandomOnDiskUsableSpaceStrategy();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        try {
            this.selectStrategy.setFolders(folders);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw e;
        }
    }

    public String getNextFolder() throws DiskSpaceInsufficientException {
        try {
            return this.folders.get(this.selectStrategy.nextFolderIndex());
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("All folders are full, change system mode to read-only.", (Throwable)((Object)e));
            CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
            throw e;
        }
    }
}

