/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.mpp.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.mpp.metric.TimeSeriesMetadataCacheMetrics;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesMetadataCache {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesMetadataCache.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE = config.getAllocateMemoryForTimeSeriesMetaDataCache();
    private static final boolean CACHE_ENABLE = config.isMetaDataCacheEnable();
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private final Cache<TimeSeriesMetadataCacheKey, TimeseriesMetadata> lruCache;
    private final AtomicLong entryAverageSize = new AtomicLong(0L);
    private final Map<String, WeakReference<String>> devices = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEPARATOR = "$";

    private TimeSeriesMetadataCache() {
        if (CACHE_ENABLE) {
            logger.info("TimeseriesMetadataCache size = {}", (Object)MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE);
        }
        this.lruCache = Caffeine.newBuilder().maximumWeight(MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE).weigher((key, value) -> (int)(RamUsageEstimator.shallowSizeOf((Object)key) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).device) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).measurement) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).tsFilePrefixPath) + RamUsageEstimator.sizeOf((Object)((TimeSeriesMetadataCacheKey)key).tsFileVersion) + RamUsageEstimator.shallowSizeOf((Object)value) + RamUsageEstimator.sizeOf((Object)value.getMeasurementId()) + RamUsageEstimator.shallowSizeOf((Object)value.getStatistics()) + (value.getChunkMetadataList().get(0) == null ? 0L : ((ChunkMetadata)value.getChunkMetadataList().get(0)).calculateRamSize() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF) * (long)value.getChunkMetadataList().size() + RamUsageEstimator.shallowSizeOf((Object)value.getChunkMetadataList()))).recordStats().build();
        MetricService.getInstance().addMetricSet((IMetricSet)new TimeSeriesMetadataCacheMetrics(this));
    }

    public static TimeSeriesMetadataCache getInstance() {
        return TimeSeriesMetadataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeseriesMetadata get(TimeSeriesMetadataCacheKey key, Set<String> allSensors, boolean ignoreNotExists, boolean debug) throws IOException {
        block18: {
            startTime = System.nanoTime();
            cacheHit = true;
            if (!TimeSeriesMetadataCache.CACHE_ENABLE) {
                cacheHit = false;
                reader = FileReaderManager.getInstance().get(TimeSeriesMetadataCacheKey.access$100(key), true);
                bloomFilter = reader.readBloomFilter();
                if (bloomFilter != null && !bloomFilter.contains(TimeSeriesMetadataCacheKey.access$200(key) + '.' + TimeSeriesMetadataCacheKey.access$300(key))) {
                    var10_11 = null;
                    TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                    return var10_11;
                }
                timeseriesMetadata = reader.readTimeseriesMetadata(new Path(TimeSeriesMetadataCacheKey.access$200(key), TimeSeriesMetadataCacheKey.access$300(key), true), ignoreNotExists);
                var11_14 = timeseriesMetadata == null || timeseriesMetadata.getStatistics().getCount() == 0L ? null : timeseriesMetadata;
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                return var11_14;
            }
            timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
            if (timeseriesMetadata != null) ** GOTO lbl46
            if (debug) {
                TimeSeriesMetadataCache.DEBUG_LOGGER.info("Cache miss: {}.{} in file: {}", new Object[]{TimeSeriesMetadataCacheKey.access$200(key), TimeSeriesMetadataCacheKey.access$300(key), TimeSeriesMetadataCacheKey.access$100(key)});
                TimeSeriesMetadataCache.DEBUG_LOGGER.info("Device: {}, all sensors: {}", (Object)TimeSeriesMetadataCacheKey.access$200(key), allSensors);
            }
            var9_10 /* !! */  = this.devices.computeIfAbsent(TimeSeriesMetadataCacheKey.access$200(key) + "$" + TimeSeriesMetadataCacheKey.access$100(key), (Function<String, WeakReference>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(T ), (Ljava/lang/String;)Ljava/lang/ref/WeakReference;)());
            synchronized (var9_10 /* !! */ ) {
                timeseriesMetadata = (TimeseriesMetadata)this.lruCache.getIfPresent((Object)key);
                if (timeseriesMetadata != null) ** GOTO lbl45
                cacheHit = false;
                path = new Path(TimeSeriesMetadataCacheKey.access$200(key), TimeSeriesMetadataCacheKey.access$300(key), true);
                bloomFilter = BloomFilterCache.getInstance().get(new BloomFilterCache.BloomFilterCacheKey(TimeSeriesMetadataCacheKey.access$100(key)), debug);
                if (bloomFilter == null || bloomFilter.contains(path.getFullPath())) ** break block17
                if (debug) {
                    TimeSeriesMetadataCache.DEBUG_LOGGER.info("TimeSeries meta data {} is filter by bloomFilter!", (Object)key);
                }
                var12_16 = null;
            }
            TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
            return var12_16;
            {
                reader = FileReaderManager.getInstance().get(TimeSeriesMetadataCacheKey.access$100(key), true);
                timeSeriesMetadataList = reader.readTimeseriesMetadata(path, allSensors);
                for (TimeseriesMetadata metadata : timeSeriesMetadataList) {
                    k = new TimeSeriesMetadataCacheKey(TimeSeriesMetadataCacheKey.access$100(key), TimeSeriesMetadataCacheKey.access$200(key), metadata.getMeasurementId());
                    if (metadata.getStatistics().getCount() != 0L) {
                        this.lruCache.put((Object)k, (Object)metadata);
                    }
                    if (!metadata.getMeasurementId().equals(TimeSeriesMetadataCacheKey.access$300(key))) continue;
                    timeseriesMetadata = metadata.getStatistics().getCount() == 0L ? null : metadata;
                }
lbl45:
                // 2 sources

                // MONITOREXIT @DISABLED, blocks:[4, 7] lbl47 : MonitorExitStatement: MONITOREXIT : var9_10 /* !! */ 
lbl46:
                // 2 sources

                if (timeseriesMetadata != null) break block18;
                if (debug) {
                    TimeSeriesMetadataCache.DEBUG_LOGGER.info("The file doesn't have this time series {}.", (Object)key);
                }
                var9_10 /* !! */  = null;
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                return var9_10 /* !! */ ;
            }
        }
        if (debug) {
            TimeSeriesMetadataCache.DEBUG_LOGGER.info("Get timeseries: {}.{}  metadata in file: {}  from cache: {}.", new Object[]{TimeSeriesMetadataCacheKey.access$200(key), TimeSeriesMetadataCacheKey.access$300(key), TimeSeriesMetadataCacheKey.access$100(key), timeseriesMetadata});
        }
        var9_10 /* !! */  = new TimeseriesMetadata(timeseriesMetadata);
        TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
        return var9_10 /* !! */ ;
        {
            catch (Throwable var18_22) {
                TimeSeriesMetadataCache.SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost(cacheHit != false ? "read_timeseries_metadata_cache" : "read_timeseries_metadata_file", System.nanoTime() - startTime);
                throw var18_22;
            }
        }
    }

    public double calculateTimeSeriesMetadataHitRatio() {
        return this.lruCache.stats().hitRate();
    }

    public long getEvictionCount() {
        return this.lruCache.stats().evictionCount();
    }

    public long getMaxMemory() {
        return MEMORY_THRESHOLD_IN_TIME_SERIES_METADATA_CACHE;
    }

    public double getAverageLoadPenalty() {
        return this.lruCache.stats().averageLoadPenalty();
    }

    public long getAverageSize() {
        return this.entryAverageSize.get();
    }

    public double calculateBloomFilterHitRatio() {
        return BloomFilterCache.getInstance().calculateBloomFilterHitRatio();
    }

    public void clear() {
        this.lruCache.invalidateAll();
        this.lruCache.cleanUp();
    }

    public void remove(TimeSeriesMetadataCacheKey key) {
        this.lruCache.invalidate((Object)key);
    }

    public boolean isEmpty() {
        return this.lruCache.asMap().isEmpty();
    }

    private static class TimeSeriesMetadataCacheHolder {
        private static final TimeSeriesMetadataCache INSTANCE = new TimeSeriesMetadataCache();

        private TimeSeriesMetadataCacheHolder() {
        }
    }

    public static class TimeSeriesMetadataCacheKey {
        private final String filePath;
        private final String tsFilePrefixPath;
        private final long tsFileVersion;
        private final long compactionVersion;
        private final String device;
        private final String measurement;

        public TimeSeriesMetadataCacheKey(String filePath, String device, String measurement) {
            this.filePath = filePath;
            Pair tsFilePrefixPathAndTsFileVersionPair = FilePathUtils.getTsFilePrefixPathAndTsFileVersionPair((String)filePath);
            this.tsFilePrefixPath = (String)tsFilePrefixPathAndTsFileVersionPair.left;
            this.tsFileVersion = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[0];
            this.compactionVersion = ((long[])tsFilePrefixPathAndTsFileVersionPair.right)[1];
            this.device = device;
            this.measurement = measurement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeriesMetadataCacheKey that = (TimeSeriesMetadataCacheKey)o;
            return Objects.equals(this.measurement, that.measurement) && Objects.equals(this.device, that.device) && this.tsFileVersion == that.tsFileVersion && this.compactionVersion == that.compactionVersion && this.tsFilePrefixPath.equals(that.tsFilePrefixPath);
        }

        public int hashCode() {
            return Objects.hash(this.tsFilePrefixPath, this.tsFileVersion, this.compactionVersion, this.device, this.measurement);
        }

        static /* synthetic */ String access$100(TimeSeriesMetadataCacheKey x0) {
            return x0.filePath;
        }
    }
}

