/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.recover;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.iotdb.db.conf.directories.TierManager;
import org.apache.iotdb.db.engine.compaction.execute.recover.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final TsFileManager tsFileManager;
    private final String logicalStorageGroupName;
    private final String dataRegionId;

    public CompactionRecoverManager(TsFileManager tsFileManager, String logicalStorageGroupName, String dataRegionId) {
        this.tsFileManager = tsFileManager;
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
    }

    public void recoverInnerSpaceCompaction(boolean isSequence) {
        logger.info("recovering inner compaction");
        this.recoverCompactionBefore013(true);
        this.recoverCompaction(true, isSequence);
    }

    public void recoverCrossSpaceCompaction() {
        logger.info("recovering cross compaction");
        this.recoverCompactionBefore013(false);
        this.recoverCompaction(false, true);
    }

    private void recoverCompaction(boolean isInnerSpace, boolean isLogSequence) {
        List<String> dirs = isLogSequence ? TierManager.getInstance().getAllLocalSequenceFileFolders() : TierManager.getInstance().getAllLocalUnSequenceFileFolders();
        for (String dir : dirs) {
            File storageGroupDir = new File(dir + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId);
            if (!storageGroupDir.exists()) {
                return;
            }
            File[] timePartitionDirs = storageGroupDir.listFiles();
            if (timePartitionDirs == null) {
                return;
            }
            for (File timePartitionDir : timePartitionDirs) {
                File[] compactionLogs;
                if (!timePartitionDir.isDirectory() || !Pattern.compile("[0-9]*").matcher(timePartitionDir.getName()).matches()) continue;
                for (File compactionLog : compactionLogs = CompactionLogger.findCompactionLogs(isInnerSpace, timePartitionDir.getPath())) {
                    logger.info("Calling compaction recover task.");
                    new CompactionRecoverTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, compactionLog, isInnerSpace).doCompaction();
                }
            }
        }
    }

    private void recoverCompactionBefore013(boolean isInnerSpace) {
        String oldLogName = isInnerSpace ? this.logicalStorageGroupName + ".compaction.log" : "merge.log";
        File logFileFromOld = FSFactoryProducer.getFSFactory().getFile(this.tsFileManager.getStorageGroupDir(), oldLogName);
        if (logFileFromOld.exists()) {
            logger.info("Calling compaction task to recover from previous version.");
            new CompactionRecoverTask(this.logicalStorageGroupName, this.dataRegionId, this.tsFileManager, logFileFromOld, isInnerSpace).doCompaction();
        }
    }
}

