/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.selector.estimator.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointCrossCompactionEstimator
extends AbstractCrossSpaceEstimator {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private long maxCostOfReadingSeqFile = 0L;
    private long maxCostOfWritingTargetFile = 0L;
    private int maxConcurrentSeriesNum = 1;
    private final int subCompactionTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        if (!this.addReadLock(seqResources, unseqResource)) {
            return -1L;
        }
        try {
            long cost = 0L;
            cost += this.calculateReadingUnseqFile(unseqResource);
            cost += this.calculateReadingSeqFiles(seqResources);
            long l = cost += this.calculatingWritingTargetFiles(seqResources, unseqResource);
            return l;
        }
        finally {
            this.releaseReadLock(seqResources, unseqResource);
        }
    }

    private boolean addReadLock(List<TsFileResource> seqResources, TsFileResource unseqResource) {
        ArrayList<TsFileResource> allResources = new ArrayList<TsFileResource>(seqResources);
        allResources.add(unseqResource);
        for (int i = 0; i < allResources.size(); ++i) {
            TsFileResource resource = (TsFileResource)allResources.get(i);
            resource.readLock();
            if (!resource.isDeleted()) continue;
            for (int j = 0; j <= i; ++j) {
                ((TsFileResource)allResources.get(j)).readUnlock();
            }
            return false;
        }
        return true;
    }

    private void releaseReadLock(List<TsFileResource> seqResources, TsFileResource unseqResource) {
        seqResources.forEach(TsFileResource::readUnlock);
        unseqResource.readUnlock();
    }

    private long calculateReadingUnseqFile(TsFileResource unseqResource) throws IOException {
        TsFileSequenceReader reader = this.getFileReader(unseqResource);
        FileInfo fileInfo = this.getSeriesAndDeviceChunkNum(reader);
        int concurrentSeriesNum = fileInfo.maxAlignedSeriesNumInDevice == -1 ? this.subCompactionTaskNum : fileInfo.maxAlignedSeriesNumInDevice;
        this.maxConcurrentSeriesNum = Math.max(this.maxConcurrentSeriesNum, concurrentSeriesNum);
        if (fileInfo.totalChunkNum == 0) {
            logger.warn("calculateReadingUnseqFile(), find 1 empty unSeq tsFile: {}.", (Object)unseqResource.getTsFilePath());
            return 0L;
        }
        return this.compressionRatio * (long)concurrentSeriesNum * (unseqResource.getTsFileSize() * (long)fileInfo.maxSeriesChunkNum / (long)fileInfo.totalChunkNum);
    }

    private long calculateReadingSeqFiles(List<TsFileResource> seqResources) throws IOException {
        long cost = 0L;
        for (TsFileResource seqResource : seqResources) {
            long seqFileCost;
            TsFileSequenceReader reader = this.getFileReader(seqResource);
            FileInfo fileInfo = this.getSeriesAndDeviceChunkNum(reader);
            int concurrentSeriesNum = fileInfo.maxAlignedSeriesNumInDevice == -1 ? this.subCompactionTaskNum : fileInfo.maxAlignedSeriesNumInDevice;
            this.maxConcurrentSeriesNum = Math.max(this.maxConcurrentSeriesNum, concurrentSeriesNum);
            if (fileInfo.totalChunkNum == 0) {
                logger.warn("calculateReadingSeqFiles(), find 1 empty seq tsFile: {}.", (Object)seqResource.getTsFilePath());
                seqFileCost = 0L;
            } else {
                seqFileCost = this.compressionRatio * seqResource.getTsFileSize() * (long)concurrentSeriesNum / (long)fileInfo.totalChunkNum;
            }
            if (seqFileCost <= this.maxCostOfReadingSeqFile) continue;
            cost -= this.maxCostOfReadingSeqFile;
            cost += seqFileCost;
            this.maxCostOfReadingSeqFile = seqFileCost;
        }
        return cost;
    }

    private long calculatingWritingTargetFiles(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        long cost = 0L;
        for (TsFileResource seqResource : seqResources) {
            TsFileSequenceReader reader = this.getFileReader(seqResource);
            cost += reader.getFileMetadataSize();
        }
        cost += this.getFileReader(unseqResource).getFileMetadataSize();
        long writingTargetCost = (long)this.maxConcurrentSeriesNum * this.config.getTargetChunkSize();
        if (writingTargetCost > this.maxCostOfWritingTargetFile) {
            cost -= this.maxCostOfWritingTargetFile;
            cost += writingTargetCost;
            this.maxCostOfWritingTargetFile = writingTargetCost;
        }
        return cost;
    }

    private FileInfo getSeriesAndDeviceChunkNum(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        Map deviceMetadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : deviceMetadata.entrySet()) {
            int deviceChunkNum = 0;
            List deviceTimeseriesMetadata = (List)entry.getValue();
            if (((TimeseriesMetadata)deviceTimeseriesMetadata.get(0)).getMeasurementId().equals("")) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, deviceTimeseriesMetadata.size());
            }
            for (TimeseriesMetadata timeseriesMetadata : deviceTimeseriesMetadata) {
                deviceChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                totalChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                maxChunkNum = Math.max(maxChunkNum, timeseriesMetadata.getChunkMetadataList().size());
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
        }
        return new FileInfo(totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum);
    }

    private class FileInfo {
        public int totalChunkNum = 0;
        public int maxSeriesChunkNum = 0;
        public int maxAlignedSeriesNumInDevice = -1;
        public int maxDeviceChunkNum = 0;

        public FileInfo(int totalChunkNum, int maxSeriesChunkNum, int maxAlignedSeriesNumInDevice, int maxDeviceChunkNum) {
            this.totalChunkNum = totalChunkNum;
            this.maxSeriesChunkNum = maxSeriesChunkNum;
            this.maxAlignedSeriesNumInDevice = maxAlignedSeriesNumInDevice;
            this.maxDeviceChunkNum = maxDeviceChunkNum;
        }
    }
}

