/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheEntry;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.CacheManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.MemManager;

public class PlainCacheManager
extends CacheManager {
    private volatile Map<CacheEntry, ICachedMNode> nodeCache = new ConcurrentHashMap<CacheEntry, ICachedMNode>();

    public PlainCacheManager(MemManager memManager) {
        super(memManager);
    }

    @Override
    protected void updateCacheStatusAfterAccess(CacheEntry cacheEntry) {
    }

    @Override
    protected void updateCacheStatusAfterUpdate(CacheEntry cacheEntry, ICachedMNode node) {
        this.nodeCache.replace(cacheEntry, node);
    }

    @Override
    protected boolean isInNodeCache(CacheEntry cacheEntry) {
        return this.nodeCache.containsKey(cacheEntry);
    }

    @Override
    protected void addToNodeCache(CacheEntry cacheEntry, ICachedMNode node) {
        this.nodeCache.put(cacheEntry, node);
    }

    @Override
    protected void removeFromNodeCache(CacheEntry cacheEntry) {
        this.nodeCache.remove(cacheEntry);
    }

    @Override
    protected ICachedMNode getPotentialNodeTobeEvicted() {
        for (CacheEntry cacheEntry : this.nodeCache.keySet()) {
            if (cacheEntry.isPinned()) continue;
            return this.nodeCache.get(cacheEntry);
        }
        return null;
    }

    @Override
    protected void clearNodeCache() {
        this.nodeCache.clear();
    }

    @Override
    public long getCacheNodeNum() {
        return this.nodeCache.size();
    }
}

