/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v2.handler;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.connector.v2.IoTDBThriftConnectorV2;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferTabletInsertionEventHandler<E extends TPipeTransferResp>
implements AsyncMethodCallback<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletInsertionEventHandler.class);
    private final long requestCommitId;
    private final EnrichedEvent event;
    private final TPipeTransferReq req;
    private final IoTDBThriftConnectorV2 connector;
    private static final long MAX_RETRY_WAIT_TIME_MS = (long)((double)PipeConfig.getInstance().getPipeConnectorRetryIntervalMs() * Math.pow(2.0, 5.0));
    private int retryCount = 0;

    protected PipeTransferTabletInsertionEventHandler(long requestCommitId, @Nullable EnrichedEvent event, TPipeTransferReq req, IoTDBThriftConnectorV2 connector) {
        this.requestCommitId = requestCommitId;
        this.event = event;
        this.req = req;
        this.connector = connector;
        Optional.ofNullable(event).ifPresent(e -> e.increaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName()));
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        this.doTransfer(client, this.req);
    }

    protected abstract void doTransfer(AsyncPipeDataTransferServiceClient var1, TPipeTransferReq var2) throws TException;

    public void onComplete(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return;
        }
        if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.connector.commit(this.requestCommitId, this.event);
        } else {
            this.onError((Exception)((Object)new PipeException(response.getStatus().getMessage())));
        }
    }

    public void onError(Exception exception) {
        ++this.retryCount;
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(Math.min((long)((double)PipeConfig.getInstance().getPipeConnectorRetryIntervalMs() * Math.pow(2.0, (double)this.retryCount - 1.0)), MAX_RETRY_WAIT_TIME_MS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Unexpected interruption during retrying", (Throwable)e);
            }
            if (this.connector.isClosed()) {
                LOGGER.info("IoTDBThriftConnectorV2 has been stopped, we will not retry this request {} after {} times", new Object[]{this.req, this.retryCount, exception});
            } else {
                LOGGER.warn("IoTDBThriftConnectorV2 failed to transfer request {} after {} times, retrying...", new Object[]{this.req, this.retryCount, exception});
                this.retryTransfer(this.connector, this.requestCommitId);
            }
        });
    }

    protected abstract void retryTransfer(IoTDBThriftConnectorV2 var1, long var2);
}

