/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum MetadataIndexNodeType {
    INTERNAL_DEVICE,
    LEAF_DEVICE,
    INTERNAL_MEASUREMENT,
    LEAF_MEASUREMENT;


    public static MetadataIndexNodeType deserialize(byte i) {
        if (i >= 4) {
            throw new IllegalArgumentException("Invalid input: " + i);
        }
        switch (i) {
            case 0: {
                return INTERNAL_DEVICE;
            }
            case 1: {
                return LEAF_DEVICE;
            }
            case 2: {
                return INTERNAL_MEASUREMENT;
            }
        }
        return LEAF_MEASUREMENT;
    }

    public static MetadataIndexNodeType deserializeFrom(ByteBuffer buffer) {
        return MetadataIndexNodeType.deserialize(buffer.get());
    }

    public static int getSerializedSize() {
        return 1;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public byte serialize() {
        switch (this) {
            case INTERNAL_DEVICE: {
                return 0;
            }
            case LEAF_DEVICE: {
                return 1;
            }
            case INTERNAL_MEASUREMENT: {
                return 2;
            }
            case LEAF_MEASUREMENT: {
                return 3;
            }
        }
        return -1;
    }
}

