/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderByTimestamp;

public class DataSetWithTimeGenerator
extends QueryDataSet {
    private TimeGenerator timeGenerator;
    private List<FileSeriesReaderByTimestamp> readers;
    private List<Boolean> cached;

    public DataSetWithTimeGenerator(List<Path> paths, List<Boolean> cached, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<FileSeriesReaderByTimestamp> readers) {
        super(paths, dataTypes);
        this.cached = cached;
        this.timeGenerator = timeGenerator;
        this.readers = readers;
    }

    @Override
    protected boolean hasNextWithoutConstraint() throws IOException {
        return this.timeGenerator.hasNext();
    }

    @Override
    protected RowRecord nextWithoutConstraint() throws IOException {
        long timestamp = this.timeGenerator.next();
        RowRecord rowRecord = new RowRecord(timestamp);
        for (int i = 0; i < this.paths.size(); ++i) {
            if (this.cached.get(i).booleanValue()) {
                Object value = this.timeGenerator.getValue((Path)this.paths.get(i), timestamp);
                rowRecord.addField(value, (TSDataType)((Object)this.dataTypes.get(i)));
                continue;
            }
            FileSeriesReaderByTimestamp fileSeriesReaderByTimestamp = this.readers.get(i);
            Object value = fileSeriesReaderByTimestamp.getValueInTimestamp(timestamp);
            rowRecord.addField(value, (TSDataType)((Object)this.dataTypes.get(i)));
        }
        return rowRecord;
    }
}

