/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.utils.Binary;

public class BinaryArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        if (TSDataType.TEXT.equals((Object)dataType)) {
            BinaryColumnBuilder columnBuilder = new BinaryColumnBuilder(null, positionCount);
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    int length = input.getInt();
                    byte[] value = new byte[length];
                    input.get(value);
                    columnBuilder.writeBinary(new Binary(value));
                    continue;
                }
                columnBuilder.appendNull();
            }
            return columnBuilder.build();
        }
        throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.TEXT.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                Binary binary = column.getBinary(i);
                output.writeInt(binary.getLength());
                output.write(binary.getValues());
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
    }
}

