/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumnBuilder;

public class Int32ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        ColumnBuilder columnBuilder;
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        if (TSDataType.INT32.equals((Object)dataType)) {
            columnBuilder = new IntColumnBuilder(null, positionCount);
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    columnBuilder.writeInt(input.getInt());
                    continue;
                }
                columnBuilder.appendNull();
            }
        } else if (TSDataType.FLOAT.equals((Object)dataType)) {
            columnBuilder = new FloatColumnBuilder(null, positionCount);
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators == null || !nullIndicators[i]) {
                    columnBuilder.writeFloat(Float.intBitsToFloat(input.getInt()));
                    continue;
                }
                columnBuilder.appendNull();
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        return columnBuilder.build();
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.INT32.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeInt(column.getInt(i));
            }
        } else if (TSDataType.FLOAT.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                output.writeInt(Float.floatToIntBits(column.getFloat(i)));
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
    }
}

