/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Tablet {
    private static final int DEFAULT_SIZE = 1024;
    private static final String NOT_SUPPORT_DATATYPE = "Data type %s is not supported.";
    public String deviceId;
    private List<MeasurementSchema> schemas;
    private final Map<String, Integer> measurementIndex;
    public long[] timestamps;
    public Object[] values;
    public BitMap[] bitMaps;
    public int rowSize;
    private final int maxRowNumber;

    public Tablet(String deviceId, List<MeasurementSchema> schemas) {
        this(deviceId, schemas, 1024);
    }

    public Tablet(String deviceId, List<MeasurementSchema> schemas, int maxRowNumber) {
        this.deviceId = deviceId;
        this.schemas = new ArrayList<MeasurementSchema>(schemas);
        this.maxRowNumber = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        int indexInSchema = 0;
        for (MeasurementSchema schema : schemas) {
            this.measurementIndex.put(schema.getMeasurementId(), indexInSchema);
            ++indexInSchema;
        }
        this.createColumns();
        this.reset();
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setSchemas(List<MeasurementSchema> schemas) {
        this.schemas = schemas;
    }

    public void initBitMaps() {
        this.bitMaps = new BitMap[this.schemas.size()];
        for (int column = 0; column < this.schemas.size(); ++column) {
            this.bitMaps[column] = new BitMap(this.getMaxRowNumber());
        }
    }

    public void addTimestamp(int rowIndex, long timestamp) {
        this.timestamps[rowIndex] = timestamp;
    }

    public void addValue(String measurementId, int rowIndex, Object value) {
        int indexOfSchema = this.measurementIndex.get(measurementId);
        MeasurementSchema measurementSchema = this.schemas.get(indexOfSchema);
        this.addValueOfDataType(measurementSchema.getType(), rowIndex, indexOfSchema, value);
    }

    private void addValueOfDataType(TSDataType dataType, int rowIndex, int indexOfSchema, Object value) {
        if (value == null) {
            if (this.bitMaps == null) {
                this.bitMaps = new BitMap[this.values.length];
            }
            if (this.bitMaps[indexOfSchema] == null) {
                this.bitMaps[indexOfSchema] = new BitMap(this.maxRowNumber);
            }
            this.bitMaps[indexOfSchema].mark(rowIndex);
        }
        switch (dataType) {
            case TEXT: {
                Binary[] sensor = (Binary[])this.values[indexOfSchema];
                if (value instanceof Binary) {
                    sensor[rowIndex] = value != null ? (Binary)value : Binary.EMPTY_VALUE;
                    break;
                }
                sensor[rowIndex] = value != null ? new Binary((String)value) : Binary.EMPTY_VALUE;
                break;
            }
            case FLOAT: {
                float[] sensor = (float[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? ((Float)value).floatValue() : Float.MIN_VALUE;
                break;
            }
            case INT32: {
                int[] sensor = (int[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Integer)value : Integer.MIN_VALUE;
                break;
            }
            case INT64: {
                long[] sensor = (long[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Long)value : Long.MIN_VALUE;
                break;
            }
            case DOUBLE: {
                double[] sensor = (double[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Double)value : Double.MIN_VALUE;
                break;
            }
            case BOOLEAN: {
                boolean[] sensor = (boolean[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null && (Boolean)value != false;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{dataType}));
            }
        }
    }

    public List<MeasurementSchema> getSchemas() {
        return this.schemas;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void reset() {
        this.rowSize = 0;
        if (this.bitMaps != null) {
            for (BitMap bitMap : this.bitMaps) {
                if (bitMap == null) continue;
                bitMap.reset();
            }
        }
    }

    private void createColumns() {
        this.timestamps = new long[this.maxRowNumber];
        int valueColumnsSize = this.schemas.size();
        this.values = new Object[valueColumnsSize];
        int columnIndex = 0;
        for (MeasurementSchema schema : this.schemas) {
            TSDataType dataType = schema.getType();
            this.values[columnIndex] = this.createValueColumnOfDataType(dataType);
            ++columnIndex;
        }
    }

    private Object createValueColumnOfDataType(TSDataType dataType) {
        Object[] valueColumn;
        switch (dataType) {
            case INT32: {
                valueColumn = new int[this.maxRowNumber];
                break;
            }
            case INT64: {
                valueColumn = new long[this.maxRowNumber];
                break;
            }
            case FLOAT: {
                valueColumn = new float[this.maxRowNumber];
                break;
            }
            case DOUBLE: {
                valueColumn = new double[this.maxRowNumber];
                break;
            }
            case BOOLEAN: {
                valueColumn = new boolean[this.maxRowNumber];
                break;
            }
            case TEXT: {
                valueColumn = new Binary[this.maxRowNumber];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{dataType}));
            }
        }
        return valueColumn;
    }

    public int getTimeBytesSize() {
        return this.rowSize * 8;
    }

    public int getTotalValueOccupation() {
        int valueOccupation = 0;
        int columnIndex = 0;
        for (MeasurementSchema schema : this.schemas) {
            valueOccupation += this.calOccupationOfOneColumn(schema.getType(), columnIndex);
            ++columnIndex;
        }
        if (this.bitMaps != null) {
            for (BitMap bitMap : this.bitMaps) {
                ++valueOccupation;
                if (bitMap == null || bitMap.isAllUnmarked()) continue;
                valueOccupation += this.rowSize / 8 + 1;
            }
        }
        return valueOccupation;
    }

    private int calOccupationOfOneColumn(TSDataType dataType, int columnIndex) {
        int valueOccupation = 0;
        switch (dataType) {
            case BOOLEAN: {
                valueOccupation += this.rowSize;
                break;
            }
            case FLOAT: 
            case INT32: {
                valueOccupation += this.rowSize * 4;
                break;
            }
            case INT64: 
            case DOUBLE: {
                valueOccupation += this.rowSize * 8;
                break;
            }
            case TEXT: {
                valueOccupation += this.rowSize * 4;
                Binary[] binaries = (Binary[])this.values[columnIndex];
                for (int rowIndex = 0; rowIndex < this.rowSize; ++rowIndex) {
                    valueOccupation += binaries[rowIndex].getLength();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, new Object[]{dataType}));
            }
        }
        return valueOccupation;
    }
}

