/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.tsfile.exception.PathParseException;
import org.apache.iotdb.tsfile.read.common.parser.PathNodesGenerator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = 3405277066329298200L;
    private String measurement;
    protected String device;
    protected String fullPath;
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";

    public Path() {
    }

    public Path(String pathSc) {
        this(pathSc, false);
    }

    public Path(String pathSc, boolean needSplit) {
        if (pathSc == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needSplit) {
            this.fullPath = pathSc;
        } else if (pathSc.length() > 0) {
            String[] nodes = PathNodesGenerator.splitPathToNodes(pathSc);
            this.device = "";
            if (nodes.length > 1) {
                this.device = this.transformNodesToString(nodes, nodes.length - 1);
            }
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.transformNodesToString(nodes, nodes.length);
        } else {
            this.fullPath = pathSc;
            this.device = "";
            this.measurement = pathSc;
        }
    }

    public Path(String device, String measurement) {
        if (device == null || measurement == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!StringUtils.isEmpty((CharSequence)device) && !StringUtils.isEmpty((CharSequence)measurement)) {
            String path = device + "." + measurement;
            String[] nodes = PathNodesGenerator.splitPathToNodes(path);
            this.device = this.transformNodesToString(nodes, nodes.length - 1);
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.transformNodesToString(nodes, nodes.length);
        } else if (!StringUtils.isEmpty((CharSequence)device)) {
            String[] deviceNodes = PathNodesGenerator.splitPathToNodes(device);
            this.device = this.transformNodesToString(deviceNodes, deviceNodes.length);
            this.measurement = measurement;
            this.fullPath = device + "." + measurement;
        } else if (!StringUtils.isEmpty((CharSequence)measurement)) {
            String[] measurementNodes = PathNodesGenerator.splitPathToNodes(measurement);
            this.measurement = this.transformNodesToString(measurementNodes, measurementNodes.length);
            this.device = device;
            this.fullPath = measurement;
        } else {
            this.device = device;
            this.measurement = measurement;
            this.fullPath = "";
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getFullPathWithAlias() {
        throw new IllegalArgumentException("doesn't alias in TSFile Path");
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return this.fullPath.equals(obj);
    }

    @Override
    public int compareTo(Path path) {
        return this.fullPath.compareTo(path.getFullPath());
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }

    public int getColumnNum() {
        return 1;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)3, byteBuffer);
        this.serializeWithoutType(byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)3, (OutputStream)stream);
        this.serializeWithoutType(stream);
    }

    protected void serializeWithoutType(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write(this.measurement, byteBuffer);
        ReadWriteIOUtils.write(this.device, byteBuffer);
        ReadWriteIOUtils.write(this.fullPath, byteBuffer);
    }

    protected void serializeWithoutType(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.measurement, (OutputStream)stream);
        ReadWriteIOUtils.write(this.device, (OutputStream)stream);
        ReadWriteIOUtils.write(this.fullPath, (OutputStream)stream);
    }

    public static Path deserialize(ByteBuffer byteBuffer) {
        Path path = new Path();
        path.measurement = ReadWriteIOUtils.readString(byteBuffer);
        path.device = ReadWriteIOUtils.readString(byteBuffer);
        path.fullPath = ReadWriteIOUtils.readString(byteBuffer);
        return path;
    }

    private String transformNodesToString(String[] nodes, int index) {
        Validate.isTrue((nodes.length > 0 ? 1 : 0) != 0);
        StringBuilder s = new StringBuilder(nodes[0]);
        for (int i = 1; i < index; ++i) {
            s.append(".");
            s.append(nodes[i]);
        }
        return s.toString();
    }
}

