/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryArrayColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.ByteArrayColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.Int32ArrayColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.Int64ArrayColumnEncoder;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthColumnEncoder;

public class ColumnEncoderFactory {
    private static final Map<ColumnEncoding, ColumnEncoder> encodingToEncoder = new HashMap<ColumnEncoding, ColumnEncoder>();

    public static ColumnEncoder get(ColumnEncoding columnEncoding) {
        if (!encodingToEncoder.containsKey((Object)columnEncoding)) {
            throw new IllegalArgumentException("Unsupported column encoding: " + (Object)((Object)columnEncoding));
        }
        return encodingToEncoder.get((Object)columnEncoding);
    }

    static {
        encodingToEncoder.put(ColumnEncoding.INT32_ARRAY, new Int32ArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.INT64_ARRAY, new Int64ArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.BYTE_ARRAY, new ByteArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.BINARY_ARRAY, new BinaryArrayColumnEncoder());
        encodingToEncoder.put(ColumnEncoding.RLE, new RunLengthColumnEncoder());
    }
}

