/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.cache;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.common.cache.Cache;

public abstract class LRUCache<K, T>
implements Cache<K, T> {
    private int cacheSize;
    private Map<K, T> cache;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new LinkedHashMap<K, T>();
    }

    @Override
    public T get(K key) throws IOException {
        if (this.cache.containsKey(key)) {
            this.moveObjectToTail(key);
        } else {
            this.removeFirstObjectIfCacheIsFull();
            this.cache.put(key, this.loadObjectByKey(key));
        }
        return this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    private void moveObjectToTail(K key) {
        T value = this.cache.get(key);
        this.cache.remove(key);
        this.cache.put(key, value);
    }

    private void removeFirstObjectIfCacheIsFull() {
        if (this.cache.size() == this.cacheSize) {
            this.removeFirstObject();
        }
    }

    private void removeFirstObject() {
        if (this.cache.size() == 0) {
            return;
        }
        K key = this.cache.keySet().iterator().next();
        this.cache.remove(key);
    }

    public void put(K key, T value) {
        this.cache.remove(key);
        this.removeFirstObjectIfCacheIsFull();
        this.cache.put(key, value);
    }

    public abstract T loadObjectByKey(K var1) throws IOException;
}

