/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.encoder.DeltaBinaryEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class FloatEncoder
extends Encoder {
    private Encoder encoder;
    private int maxPointNumber;
    private double maxPointValue;
    private boolean isMaxPointNumberSaved;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatEncoder(TSEncoding encodingType, TSDataType dataType, int maxPointNumber) {
        super(encodingType);
        this.maxPointNumber = maxPointNumber;
        this.calculateMaxPonitNum();
        this.isMaxPointNumberSaved = false;
        if (encodingType == TSEncoding.RLE) {
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new IntRleEncoder(EndianType.LITTLE_ENDIAN);
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", new Object[]{dataType}));
                this.encoder = new LongRleEncoder(EndianType.LITTLE_ENDIAN);
            }
            return;
        } else {
            if (encodingType != TSEncoding.TS_2DIFF) throw new TsFileEncodingException(String.format("%s encoding is not supported by FloatEncoder", new Object[]{encodingType}));
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new DeltaBinaryEncoder.IntDeltaEncoder();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", new Object[]{dataType}));
                this.encoder = new DeltaBinaryEncoder.LongDeltaEncoder();
            }
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        int valueInt = this.convertFloatToInt(value);
        this.encoder.encode(valueInt, out);
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        long valueLong = this.convertDoubleToLong(value);
        this.encoder.encode(valueLong, out);
    }

    private void calculateMaxPonitNum() {
        if (this.maxPointNumber <= 0) {
            this.maxPointNumber = 0;
            this.maxPointValue = 1.0;
        } else {
            this.maxPointValue = Math.pow(10.0, this.maxPointNumber);
        }
    }

    private int convertFloatToInt(float value) {
        return (int)Math.round((double)value * this.maxPointValue);
    }

    private long convertDoubleToLong(double value) {
        return Math.round(value * this.maxPointValue);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        this.encoder.flush(out);
        this.reset();
    }

    private void reset() {
        this.isMaxPointNumberSaved = false;
    }

    private void saveMaxPointNumber(ByteArrayOutputStream out) {
        if (!this.isMaxPointNumberSaved) {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(this.maxPointNumber, out);
            this.isMaxPointNumberSaved = true;
        }
    }

    @Override
    public int getOneItemMaxSize() {
        return this.encoder.getOneItemMaxSize();
    }

    @Override
    public long getMaxByteSize() {
        return this.encoder.getMaxByteSize();
    }
}

