/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupMetaData {
    private String deviceID;
    private int serializedSize;
    private long startOffsetOfChunkGroup;
    private long endOffsetOfChunkGroup;
    private List<ChunkMetaData> chunkMetaDataList;
    private long version;

    private ChunkGroupMetaData() {
        this.chunkMetaDataList = new ArrayList<ChunkMetaData>();
    }

    public ChunkGroupMetaData(String deviceID, List<ChunkMetaData> chunkMetaDataList, long startOffsetOfChunkGroup) {
        if (chunkMetaDataList == null) {
            throw new IllegalArgumentException("Given chunkMetaDataList is null");
        }
        this.deviceID = deviceID;
        this.chunkMetaDataList = chunkMetaDataList;
        this.startOffsetOfChunkGroup = startOffsetOfChunkGroup;
        this.reCalculateSerializedSize();
    }

    public static ChunkGroupMetaData deserializeFrom(InputStream inputStream) throws IOException {
        ChunkGroupMetaData chunkGroupMetaData = new ChunkGroupMetaData();
        chunkGroupMetaData.deviceID = ReadWriteIOUtils.readString(inputStream);
        chunkGroupMetaData.startOffsetOfChunkGroup = ReadWriteIOUtils.readLong(inputStream);
        chunkGroupMetaData.endOffsetOfChunkGroup = ReadWriteIOUtils.readLong(inputStream);
        chunkGroupMetaData.version = ReadWriteIOUtils.readLong(inputStream);
        int size = ReadWriteIOUtils.readInt(inputStream);
        chunkGroupMetaData.serializedSize = 4 + chunkGroupMetaData.deviceID.getBytes("UTF-8").length + 4 + 8 + 8 + 8;
        ArrayList<ChunkMetaData> chunkMetaDataList = new ArrayList<ChunkMetaData>();
        for (int i = 0; i < size; ++i) {
            ChunkMetaData metaData = ChunkMetaData.deserializeFrom(inputStream);
            chunkMetaDataList.add(metaData);
            chunkGroupMetaData.serializedSize += metaData.getSerializedSize();
        }
        chunkGroupMetaData.chunkMetaDataList = chunkMetaDataList;
        return chunkGroupMetaData;
    }

    public static ChunkGroupMetaData deserializeFrom(ByteBuffer buffer) throws IOException {
        ChunkGroupMetaData chunkGroupMetaData = new ChunkGroupMetaData();
        chunkGroupMetaData.deviceID = ReadWriteIOUtils.readString(buffer);
        chunkGroupMetaData.startOffsetOfChunkGroup = ReadWriteIOUtils.readLong(buffer);
        chunkGroupMetaData.endOffsetOfChunkGroup = ReadWriteIOUtils.readLong(buffer);
        chunkGroupMetaData.version = ReadWriteIOUtils.readLong(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        chunkGroupMetaData.serializedSize = 4 + chunkGroupMetaData.deviceID.getBytes("UTF-8").length + 4 + 8 + 8 + 8;
        ArrayList<ChunkMetaData> chunkMetaDataList = new ArrayList<ChunkMetaData>();
        for (int i = 0; i < size; ++i) {
            ChunkMetaData metaData = ChunkMetaData.deserializeFrom(buffer);
            chunkMetaDataList.add(metaData);
            chunkGroupMetaData.serializedSize += metaData.getSerializedSize();
        }
        chunkGroupMetaData.chunkMetaDataList = chunkMetaDataList;
        return chunkGroupMetaData;
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    void reCalculateSerializedSize() {
        this.serializedSize = 4 + this.deviceID.length() + 4 + 8 + 8 + 8;
        for (ChunkMetaData chunk : this.chunkMetaDataList) {
            this.serializedSize += chunk.getSerializedSize();
        }
    }

    public void addTimeSeriesChunkMetaData(ChunkMetaData metadata) {
        if (this.chunkMetaDataList == null) {
            this.chunkMetaDataList = new ArrayList<ChunkMetaData>();
        }
        this.chunkMetaDataList.add(metadata);
        this.serializedSize += metadata.getSerializedSize();
    }

    public List<ChunkMetaData> getChunkMetaDataList() {
        return this.chunkMetaDataList == null ? null : Collections.unmodifiableList(this.chunkMetaDataList);
    }

    public String toString() {
        return String.format("ChunkGroupMetaData{ time series chunk list: %s }", this.chunkMetaDataList);
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public long getStartOffsetOfChunkGroup() {
        return this.startOffsetOfChunkGroup;
    }

    public long getEndOffsetOfChunkGroup() {
        return this.endOffsetOfChunkGroup;
    }

    public void setEndOffsetOfChunkGroup(long endOffsetOfChunkGroup) {
        this.endOffsetOfChunkGroup = endOffsetOfChunkGroup;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceID, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startOffsetOfChunkGroup, outputStream);
        byteLen += ReadWriteIOUtils.write(this.endOffsetOfChunkGroup, outputStream);
        byteLen += ReadWriteIOUtils.write(this.version, outputStream);
        byteLen += ReadWriteIOUtils.write(this.chunkMetaDataList.size(), outputStream);
        for (ChunkMetaData chunkMetaData : this.chunkMetaDataList) {
            byteLen += chunkMetaData.serializeTo(outputStream);
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceID, buffer);
        byteLen += ReadWriteIOUtils.write(this.startOffsetOfChunkGroup, buffer);
        byteLen += ReadWriteIOUtils.write(this.endOffsetOfChunkGroup, buffer);
        byteLen += ReadWriteIOUtils.write(this.version, buffer);
        byteLen += ReadWriteIOUtils.write(this.chunkMetaDataList.size(), buffer);
        for (ChunkMetaData chunkMetaData : this.chunkMetaDataList) {
            byteLen += chunkMetaData.serializeTo(buffer);
        }
        return byteLen;
    }
}

