/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BinaryStatistics
extends Statistics<Binary> {
    private Binary max = new Binary("");
    private Binary min = new Binary("");
    private Binary first = new Binary("");
    private double sum;
    private Binary last = new Binary("");

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = new Binary(maxBytes);
        this.min = new Binary(minBytes);
    }

    @Override
    public Binary getMin() {
        return this.min;
    }

    @Override
    public Binary getMax() {
        return this.max;
    }

    @Override
    public Binary getFirst() {
        return this.first;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public Binary getLast() {
        return this.last;
    }

    public void initializeStats(Binary min, Binary max, Binary first, double sum, Binary last) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.sum = sum;
        this.last = last;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        BinaryStatistics stringStats = (BinaryStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(stringStats.getMin(), stringStats.getMax(), stringStats.getFirst(), stringStats.getSum(), stringStats.getLast());
            this.isEmpty = false;
        } else {
            this.updateStats(stringStats.getMin(), stringStats.getMax(), stringStats.getFirst(), stringStats.getSum(), stringStats.getLast());
        }
    }

    @Override
    public void updateStats(Binary value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, 0.0, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, 0.0, value);
            this.isEmpty = false;
        }
    }

    private void updateStats(Binary minValue, Binary maxValue, Binary firstValue, double sum, Binary lastValue) {
        if (minValue.compareTo(this.min) < 0) {
            this.min = minValue;
        }
        if (maxValue.compareTo(this.max) > 0) {
            this.max = maxValue;
        }
        this.last = lastValue;
    }

    @Override
    public byte[] getMaxBytes() {
        return this.max.getValues();
    }

    @Override
    public byte[] getMinBytes() {
        return this.min.getValues();
    }

    @Override
    public byte[] getFirstBytes() {
        return this.first.getValues();
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public byte[] getLastBytes() {
        return this.last.getValues();
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ByteBuffer.wrap(this.max.getValues());
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ByteBuffer.wrap(this.min.getValues());
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ByteBuffer.wrap(this.first.getValues());
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ByteBuffer.wrap(this.last.getValues());
    }

    @Override
    public int sizeOfDatum() {
        return -1;
    }

    public String toString() {
        return "[max:" + this.max + ",min:" + this.min + ",first:" + this.first + ",sum:" + this.sum + ",last:" + this.last + "]";
    }

    @Override
    void fill(InputStream inputStream) throws IOException {
        this.min = new Binary(ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream));
        this.max = new Binary(ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream));
        this.first = new Binary(ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream));
        this.last = new Binary(ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream));
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void fill(ByteBuffer byteBuffer) throws IOException {
        this.min = new Binary(ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(byteBuffer).array());
        this.max = new Binary(ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(byteBuffer).array());
        this.first = new Binary(ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(byteBuffer).array());
        this.last = new Binary(ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(byteBuffer).array());
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }

    @Override
    protected void fill(TsFileInput input, long offset) throws IOException {
        int size = this.getSerializedSize();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ReadWriteIOUtils.readAsPossible(input, offset, buffer);
        buffer.flip();
        this.fill(buffer);
    }
}

