/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BooleanStatistics
extends Statistics<Boolean> {
    private boolean max;
    private boolean min;
    private boolean first;
    private double sum;
    private boolean last;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToBool(maxBytes);
        this.min = BytesUtils.bytesToBool(minBytes);
    }

    @Override
    public void updateStats(boolean value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, 0.0, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, 0.0, value);
            this.isEmpty = false;
        }
    }

    private void updateStats(boolean minValue, boolean maxValue, boolean firstValue, double sumValue, boolean lastValue) {
        if (!minValue && this.min) {
            this.min = false;
        }
        if (maxValue && !this.max) {
            this.max = true;
        }
        this.last = lastValue;
    }

    @Override
    public Boolean getMax() {
        return this.max;
    }

    @Override
    public Boolean getMin() {
        return this.min;
    }

    @Override
    public Boolean getFirst() {
        return this.first;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public Boolean getLast() {
        return this.last;
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        BooleanStatistics boolStats = (BooleanStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(boolStats.getMin(), boolStats.getMax(), boolStats.getFirst(), boolStats.getSum(), boolStats.getLast());
            this.isEmpty = false;
        } else {
            this.updateStats(boolStats.getMin(), boolStats.getMax(), boolStats.getFirst(), boolStats.getSum(), boolStats.getLast());
        }
    }

    public void initializeStats(boolean min, boolean max, boolean firstValue, double sumValue, boolean lastValue) {
        this.min = min;
        this.max = max;
        this.first = firstValue;
        this.last = lastValue;
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.boolToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.boolToBytes(this.min);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.boolToBytes(this.first);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.boolToBytes(this.last);
    }

    @Override
    public int sizeOfDatum() {
        return 1;
    }

    public String toString() {
        return "[max:" + this.max + ",min:" + this.min + ",first:" + this.first + ",sum:" + this.sum + ",last:" + this.last + "]";
    }

    @Override
    void fill(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readBool(inputStream);
        this.max = ReadWriteIOUtils.readBool(inputStream);
        this.first = ReadWriteIOUtils.readBool(inputStream);
        this.last = ReadWriteIOUtils.readBool(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void fill(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readBool(byteBuffer);
        this.max = ReadWriteIOUtils.readBool(byteBuffer);
        this.first = ReadWriteIOUtils.readBool(byteBuffer);
        this.last = ReadWriteIOUtils.readBool(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

