/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DoubleStatistics
extends Statistics<Double> {
    private double max;
    private double min;
    private double first;
    private double sum;
    private double last;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToDouble(maxBytes);
        this.min = BytesUtils.bytesToDouble(minBytes);
    }

    @Override
    public void updateStats(double value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
        }
    }

    private void updateStats(double minValue, double maxValue, double firstValue, double sumValue, double lastValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = lastValue;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getFirst() {
        return this.first;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public Double getLast() {
        return this.last;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        DoubleStatistics doubleStats = (DoubleStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(doubleStats.getMin(), doubleStats.getMax(), doubleStats.getFirst(), doubleStats.getSum(), doubleStats.getLast());
            this.isEmpty = false;
        } else {
            this.updateStats(doubleStats.getMin(), doubleStats.getMax(), doubleStats.getFirst(), doubleStats.getSum(), doubleStats.getLast());
        }
    }

    public void initializeStats(double min, double max, double first, double sum, double last) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.sum = sum;
        this.last = last;
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.doubleToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.doubleToBytes(this.min);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.doubleToBytes(this.first);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.doubleToBytes(this.last);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    public int sizeOfDatum() {
        return 8;
    }

    public String toString() {
        return "[max:" + this.max + ",min:" + this.min + ",first:" + this.first + ",sum:" + this.sum + ",last:" + this.last + "]";
    }

    @Override
    void fill(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readDouble(inputStream);
        this.max = ReadWriteIOUtils.readDouble(inputStream);
        this.first = ReadWriteIOUtils.readDouble(inputStream);
        this.last = ReadWriteIOUtils.readDouble(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void fill(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readDouble(byteBuffer);
        this.max = ReadWriteIOUtils.readDouble(byteBuffer);
        this.first = ReadWriteIOUtils.readDouble(byteBuffer);
        this.last = ReadWriteIOUtils.readDouble(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

