/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FloatStatistics
extends Statistics<Float> {
    private float max;
    private float min;
    private float first;
    private double sum;
    private float last;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToFloat(maxBytes);
        this.min = BytesUtils.bytesToFloat(minBytes);
    }

    @Override
    public void updateStats(float value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
        }
    }

    private void updateStats(float minValue, float maxValue, float firstValue, double sumValue, float last) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = last;
    }

    @Override
    public Float getMax() {
        return Float.valueOf(this.max);
    }

    @Override
    public Float getMin() {
        return Float.valueOf(this.min);
    }

    @Override
    public Float getFirst() {
        return Float.valueOf(this.first);
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public Float getLast() {
        return Float.valueOf(this.last);
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        FloatStatistics floatStats = (FloatStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(floatStats.getMin().floatValue(), floatStats.getMax().floatValue(), floatStats.getFirst().floatValue(), floatStats.getSum(), floatStats.getLast().floatValue());
            this.isEmpty = false;
        } else {
            this.updateStats(floatStats.getMin().floatValue(), floatStats.getMax().floatValue(), floatStats.getFirst().floatValue(), floatStats.getSum(), floatStats.getLast().floatValue());
        }
    }

    public void initializeStats(float min, float max, float first, double sum, float last) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.sum = sum;
        this.last = last;
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.floatToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.floatToBytes(this.min);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.floatToBytes(this.first);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.floatToBytes(this.last);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    public int sizeOfDatum() {
        return 4;
    }

    public String toString() {
        return "[max:" + this.max + ",min:" + this.min + ",first:" + this.first + ",sum:" + this.sum + ",last:" + this.last + "]";
    }

    @Override
    void fill(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readFloat(inputStream);
        this.max = ReadWriteIOUtils.readFloat(inputStream);
        this.first = ReadWriteIOUtils.readFloat(inputStream);
        this.last = ReadWriteIOUtils.readFloat(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void fill(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readFloat(byteBuffer);
        this.max = ReadWriteIOUtils.readFloat(byteBuffer);
        this.first = ReadWriteIOUtils.readFloat(byteBuffer);
        this.last = ReadWriteIOUtils.readFloat(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

