/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class Field {
    private TSDataType dataType;
    private boolean boolV;
    private int intV;
    private long longV;
    private float floatV;
    private double doubleV;
    private Binary binaryV;
    private boolean isNull;

    public Field(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean getBoolV() {
        return this.boolV;
    }

    public void setBoolV(boolean boolV) {
        this.boolV = boolV;
    }

    public int getIntV() {
        return this.intV;
    }

    public void setIntV(int intV) {
        this.intV = intV;
    }

    public long getLongV() {
        return this.longV;
    }

    public void setLongV(long longV) {
        this.longV = longV;
    }

    public float getFloatV() {
        return this.floatV;
    }

    public void setFloatV(float floatV) {
        this.floatV = floatV;
    }

    public double getDoubleV() {
        return this.doubleV;
    }

    public void setDoubleV(double doubleV) {
        this.doubleV = doubleV;
    }

    public Binary getBinaryV() {
        return this.binaryV;
    }

    public void setBinaryV(Binary binaryV) {
        this.binaryV = binaryV;
    }

    public String getStringValue() {
        if (this.isNull || this.dataType == null) {
            return "null";
        }
        switch (this.dataType) {
            case BOOLEAN: {
                return String.valueOf(this.boolV);
            }
            case INT32: {
                return String.valueOf(this.intV);
            }
            case INT64: {
                return String.valueOf(this.longV);
            }
            case FLOAT: {
                return String.valueOf(this.floatV);
            }
            case DOUBLE: {
                return String.valueOf(this.doubleV);
            }
            case TEXT: {
                return this.binaryV.toString();
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
    }

    public String toString() {
        return this.getStringValue();
    }

    public void setNull() {
        this.isNull = true;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public Object getObjectValue(TSDataType dataType) {
        if (this.isNull) {
            return null;
        }
        switch (dataType) {
            case DOUBLE: {
                return this.getDoubleV();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloatV());
            }
            case INT64: {
                return this.getLongV();
            }
            case INT32: {
                return this.getIntV();
            }
            case BOOLEAN: {
                return this.getBoolV();
            }
            case TEXT: {
                return this.getBinaryV();
            }
        }
        throw new UnSupportedDataTypeException("UnSupported: " + (Object)((Object)dataType));
    }
}

