/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.FileSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.DefaultTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileIOWriter {
    public static final byte[] magicStringBytes;
    private static final Logger LOG;
    protected TsFileOutput out;
    protected List<ChunkGroupMetaData> chunkGroupMetaDataList = new ArrayList<ChunkGroupMetaData>();
    private ChunkGroupMetaData currentChunkGroupMetaData;
    private ChunkMetaData currentChunkMetaData;
    protected boolean canWrite = true;
    private long markedPosition;

    protected TsFileIOWriter() {
    }

    public TsFileIOWriter(File file) throws IOException {
        this.out = new DefaultTsFileOutput(file);
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output) throws IOException {
        this.out = output;
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput out, List<ChunkGroupMetaData> chunkGroupMetaDataList) throws IOException {
        this.out = out;
        this.chunkGroupMetaDataList = chunkGroupMetaDataList;
        if (chunkGroupMetaDataList.isEmpty()) {
            this.startFile();
        }
    }

    public void writeBytesToStream(PublicBAOS bytes) throws IOException {
        bytes.writeTo(this.out.wrapAsStream());
    }

    protected void startFile() throws IOException {
        this.out.write(magicStringBytes);
    }

    public void startChunkGroup(String deviceId) throws IOException {
        LOG.debug("start chunk group:{}, file position {}", (Object)deviceId, (Object)this.out.getPosition());
        this.currentChunkGroupMetaData = new ChunkGroupMetaData(deviceId, new ArrayList<ChunkMetaData>(), this.out.getPosition());
    }

    public void endChunkGroup(long version) throws IOException {
        long dataSize = this.out.getPosition() - this.currentChunkGroupMetaData.getStartOffsetOfChunkGroup();
        ChunkGroupFooter chunkGroupFooter = new ChunkGroupFooter(this.currentChunkGroupMetaData.getDeviceID(), dataSize, this.currentChunkGroupMetaData.getChunkMetaDataList().size());
        chunkGroupFooter.serializeTo(this.out.wrapAsStream());
        this.currentChunkGroupMetaData.setEndOffsetOfChunkGroup(this.out.getPosition());
        this.currentChunkGroupMetaData.setVersion(version);
        this.chunkGroupMetaDataList.add(this.currentChunkGroupMetaData);
        LOG.debug("end chunk group:{}", (Object)this.currentChunkGroupMetaData);
        this.currentChunkGroupMetaData = null;
    }

    public int startFlushChunk(MeasurementSchema descriptor, CompressionType compressionCodecName, TSDataType tsDataType, TSEncoding encodingType, Statistics<?> statistics, long maxTime, long minTime, int dataSize, int numOfPages) throws IOException {
        LOG.debug("start series chunk:{}, file position {}", (Object)descriptor, (Object)this.out.getPosition());
        this.currentChunkMetaData = new ChunkMetaData(descriptor.getMeasurementId(), tsDataType, this.out.getPosition(), minTime, maxTime);
        ChunkHeader header = new ChunkHeader(descriptor.getMeasurementId(), dataSize, tsDataType, compressionCodecName, encodingType, numOfPages);
        header.serializeTo(this.out.wrapAsStream());
        LOG.debug("finish series chunk:{} header, file position {}", (Object)header, (Object)this.out.getPosition());
        HashMap<String, ByteBuffer> statisticsMap = new HashMap<String, ByteBuffer>();
        statisticsMap.put("max_value", ByteBuffer.wrap(statistics.getMaxBytes()));
        statisticsMap.put("min_value", ByteBuffer.wrap(statistics.getMinBytes()));
        statisticsMap.put("first", ByteBuffer.wrap(statistics.getFirstBytes()));
        statisticsMap.put("sum", ByteBuffer.wrap(statistics.getSumBytes()));
        statisticsMap.put("last", ByteBuffer.wrap(statistics.getLastBytes()));
        TsDigest tsDigest = new TsDigest();
        tsDigest.setStatistics(statisticsMap);
        this.currentChunkMetaData.setDigest(tsDigest);
        return header.getSerializedSize();
    }

    public void endChunk(long totalValueCount) {
        this.currentChunkMetaData.setNumOfPoints(totalValueCount);
        this.currentChunkGroupMetaData.addTimeSeriesChunkMetaData(this.currentChunkMetaData);
        LOG.debug("end series chunk:{},totalvalue:{}", (Object)this.currentChunkMetaData, (Object)totalValueCount);
        this.currentChunkMetaData = null;
    }

    public void endFile(FileSchema schema) throws IOException {
        ReadWriteIOUtils.write((byte)2, this.out.wrapAsStream());
        Map<String, MeasurementSchema> schemaDescriptors = schema.getAllMeasurementSchema();
        LOG.debug("get time series list:{}", schemaDescriptors);
        Map<String, TsDeviceMetadataIndex> tsDeviceMetadataIndexMap = this.flushTsDeviceMetaDataAndGetIndex(this.chunkGroupMetaDataList);
        TsFileMetaData tsFileMetaData = new TsFileMetaData(tsDeviceMetadataIndexMap, schemaDescriptors, 3);
        long footerIndex = this.out.getPosition();
        LOG.debug("start to flush the footer,file pos:{}", (Object)footerIndex);
        int size = tsFileMetaData.serializeTo(this.out.wrapAsStream());
        LOG.debug("finish flushing the footer {}, file pos:{}", (Object)tsFileMetaData, (Object)this.out.getPosition());
        ReadWriteIOUtils.write(size, this.out.wrapAsStream());
        this.out.write(magicStringBytes);
        this.out.close();
        this.canWrite = false;
        LOG.info("output stream is closed");
    }

    private Map<String, TsDeviceMetadataIndex> flushTsDeviceMetaDataAndGetIndex(List<ChunkGroupMetaData> chunkGroupMetaDataList) throws IOException {
        HashMap<String, TsDeviceMetadataIndex> tsDeviceMetadataIndexMap = new HashMap<String, TsDeviceMetadataIndex>();
        for (Map.Entry<String, TsDeviceMetadata> entry : this.getAllTsDeviceMetadata(chunkGroupMetaDataList).entrySet()) {
            TsDeviceMetadata currentTsDeviceMetadata = entry.getValue();
            long offset = this.out.getPosition();
            int size = currentTsDeviceMetadata.serializeTo(this.out.wrapAsStream());
            TsDeviceMetadataIndex tsDeviceMetadataIndex = new TsDeviceMetadataIndex(offset, size, currentTsDeviceMetadata);
            tsDeviceMetadataIndexMap.put(entry.getKey(), tsDeviceMetadataIndex);
        }
        return tsDeviceMetadataIndexMap;
    }

    private TreeMap<String, TsDeviceMetadata> getAllTsDeviceMetadata(List<ChunkGroupMetaData> chunkGroupMetaDataList) {
        TreeMap<String, TsDeviceMetadata> tsDeviceMetadataMap = new TreeMap<String, TsDeviceMetadata>();
        for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
            String currentDevice = chunkGroupMetaData.getDeviceID();
            if (!tsDeviceMetadataMap.containsKey(currentDevice)) {
                TsDeviceMetadata tsDeviceMetadata = new TsDeviceMetadata();
                tsDeviceMetadataMap.put(currentDevice, tsDeviceMetadata);
            }
            tsDeviceMetadataMap.get(currentDevice).addChunkGroupMetaData(chunkGroupMetaData);
        }
        return tsDeviceMetadataMap;
    }

    public long getPos() throws IOException {
        return this.out.getPosition();
    }

    public List<ChunkGroupMetaData> getChunkGroupMetaDatas() {
        return this.chunkGroupMetaDataList;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void mark() throws IOException {
        this.markedPosition = this.getPos();
    }

    public void reset() throws IOException {
        this.out.truncate(this.markedPosition);
    }

    public void close() throws IOException {
        this.canWrite = false;
        this.out.close();
    }

    void writeSeparatorMaskForTest() throws IOException {
        this.out.write(new byte[]{2});
    }

    void writeChunkMaskForTest() throws IOException {
        this.out.write(new byte[]{1});
    }

    public Map<String, MeasurementSchema> getKnownSchema() {
        return Collections.emptyMap();
    }

    static {
        LOG = LoggerFactory.getLogger(TsFileIOWriter.class);
        magicStringBytes = BytesUtils.stringToBytes("TsFilev0.8.0");
    }
}

