/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.util.Map;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.encoder.DeltaBinaryEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.DoublePrecisionEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.FloatEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.PlainEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.RegularDataEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.SinglePrecisionEncoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TSEncodingBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TSEncodingBuilder.class);
    protected final TSFileConfig conf = TSFileDescriptor.getInstance().getConfig();

    public static TSEncodingBuilder getConverter(TSEncoding type) {
        switch (type) {
            case PLAIN: {
                return new PLAIN();
            }
            case RLE: {
                return new RLE();
            }
            case TS_2DIFF: {
                return new TS_2DIFF();
            }
            case GORILLA: {
                return new GORILLA();
            }
            case REGULAR: {
                return new REGULAR();
            }
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public abstract Encoder getEncoder(TSDataType var1);

    public abstract void initFromProps(Map<String, String> var1);

    public String toString() {
        return "";
    }

    public static class REGULAR
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new RegularDataEncoder.IntRegularEncoder();
                }
                case INT64: {
                    return new RegularDataEncoder.LongRegularEncoder();
                }
            }
            throw new UnSupportedDataTypeException("REGULAR doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class GORILLA
    extends TSEncodingBuilder {
        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case FLOAT: {
                    return new SinglePrecisionEncoder();
                }
                case DOUBLE: {
                    return new DoublePrecisionEncoder();
                }
            }
            throw new UnSupportedDataTypeException("GORILLA doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
        }
    }

    public static class TS_2DIFF
    extends TSEncodingBuilder {
        private int maxPointNumber = 0;

        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: {
                    return new DeltaBinaryEncoder.IntDeltaEncoder();
                }
                case INT64: {
                    return new DeltaBinaryEncoder.LongDeltaEncoder();
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatEncoder(TSEncoding.TS_2DIFF, type, this.maxPointNumber);
                }
            }
            throw new UnSupportedDataTypeException("TS_2DIFF doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_point_number")) {
                this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            } else {
                this.maxPointNumber = Integer.valueOf(props.get("max_point_number"));
                if (this.maxPointNumber < 0) {
                    this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
                    logger.warn("cannot set max point number to negative value, replaced with default value:{}", (Object)this.maxPointNumber);
                }
            }
        }

        @Override
        public String toString() {
            return "max_point_number:" + this.maxPointNumber;
        }
    }

    public static class RLE
    extends TSEncodingBuilder {
        private int maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();

        @Override
        public Encoder getEncoder(TSDataType type) {
            switch (type) {
                case INT32: 
                case BOOLEAN: {
                    return new IntRleEncoder(EndianType.BIG_ENDIAN);
                }
                case INT64: {
                    return new LongRleEncoder(EndianType.BIG_ENDIAN);
                }
                case FLOAT: 
                case DOUBLE: {
                    return new FloatEncoder(TSEncoding.RLE, type, this.maxPointNumber);
                }
            }
            throw new UnSupportedDataTypeException("RLE doesn't support data type: " + (Object)((Object)type));
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_point_number")) {
                this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            } else {
                this.maxPointNumber = Integer.valueOf(props.get("max_point_number"));
                if (this.maxPointNumber < 0) {
                    this.maxPointNumber = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
                    logger.warn("cannot set max point number to negative value, replaced with default value:{}", (Object)this.maxPointNumber);
                }
            }
        }

        @Override
        public String toString() {
            return "max_point_number:" + this.maxPointNumber;
        }
    }

    public static class PLAIN
    extends TSEncodingBuilder {
        private int maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();

        @Override
        public Encoder getEncoder(TSDataType type) {
            return new PlainEncoder(EndianType.BIG_ENDIAN, type, this.maxStringLength);
        }

        @Override
        public void initFromProps(Map<String, String> props) {
            if (props == null || !props.containsKey("max_string_length")) {
                this.maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();
            } else {
                this.maxStringLength = Integer.valueOf(props.get("max_string_length"));
                if (this.maxStringLength < 0) {
                    this.maxStringLength = TSFileDescriptor.getInstance().getConfig().getMaxStringLength();
                    logger.warn("cannot set max string length to negative value, replaced with default value:{}", (Object)this.maxStringLength);
                }
            }
        }
    }
}

