/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LongStatistics
extends Statistics<Long> {
    private long min;
    private long max;
    private long first;
    private long last;
    private double sum;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.min = BytesUtils.bytesToLong(minBytes);
        this.max = BytesUtils.bytesToLong(maxBytes);
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public Long getFirst() {
        return this.first;
    }

    @Override
    public Long getLast() {
        return this.last;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public void updateStats(long value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
        }
    }

    @Override
    public void updateStats(long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (this.isEmpty) {
                this.initializeStats(values[i], values[i], values[i], values[i], values[i]);
                this.isEmpty = false;
                continue;
            }
            this.updateStats(values[i], values[i], values[i], values[i], values[i]);
        }
    }

    private void updateStats(long minValue, long maxValue, long firstValue, long lastValue, double sumValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = lastValue;
    }

    @Override
    public void updateStats(long minValue, long maxValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        LongStatistics longStats = (LongStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(longStats.getMin(), longStats.getMax(), longStats.getFirst(), longStats.getLast(), longStats.getSum());
            this.isEmpty = false;
        } else {
            this.updateStats(longStats.getMin(), longStats.getMax(), longStats.getFirst(), longStats.getLast(), longStats.getSum());
        }
    }

    private void initializeStats(long min, long max, long firstValue, long last, double sum) {
        this.min = min;
        this.max = max;
        this.first = firstValue;
        this.last = last;
        this.sum += sum;
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.longToBytes(this.min);
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.longToBytes(this.max);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.longToBytes(this.first);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.longToBytes(this.last);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    public String toString() {
        return "[min:" + this.min + ",max:" + this.max + ",first:" + this.first + ",last:" + this.last + ",sum:" + this.sum + "]";
    }

    @Override
    public int sizeOfDatum() {
        return 8;
    }

    @Override
    void deserialize(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readLong(inputStream);
        this.max = ReadWriteIOUtils.readLong(inputStream);
        this.first = ReadWriteIOUtils.readLong(inputStream);
        this.last = ReadWriteIOUtils.readLong(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readLong(byteBuffer);
        this.max = ReadWriteIOUtils.readLong(byteBuffer);
        this.first = ReadWriteIOUtils.readLong(byteBuffer);
        this.last = ReadWriteIOUtils.readLong(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

