/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class QueryDataSet {
    protected List<Path> paths;
    protected List<TSDataType> dataTypes;

    public QueryDataSet(List<Path> paths, List<TSDataType> dataTypes) {
        this.paths = paths;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet(List<Path> paths) {
        this.paths = paths;
    }

    public abstract boolean hasNext() throws IOException;

    public abstract RowRecord next() throws IOException;

    public List<Path> getPaths() {
        return this.paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    protected Field getField(Object value, TSDataType dataType) {
        if (value == null) {
            return new Field(null);
        }
        Field field = new Field(dataType);
        switch (dataType) {
            case DOUBLE: {
                field.setDoubleV((Double)value);
                break;
            }
            case FLOAT: {
                field.setFloatV(((Float)value).floatValue());
                break;
            }
            case INT64: {
                field.setLongV((Long)value);
                break;
            }
            case INT32: {
                field.setIntV((Integer)value);
                break;
            }
            case BOOLEAN: {
                field.setBoolV((Boolean)value);
                break;
            }
            case TEXT: {
                field.setBinaryV((Binary)value);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported: " + (Object)((Object)dataType));
            }
        }
        return field;
    }
}

