/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.query.dataset.DataSetWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.executor.QueryExecutor;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGeneratorImpl;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderByTimestamp;

public class ExecutorWithTimeGenerator
implements QueryExecutor {
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;

    public ExecutorWithTimeGenerator(IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader) {
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
    }

    @Override
    public DataSetWithTimeGenerator execute(QueryExpression queryExpression) throws IOException {
        IExpression expression = queryExpression.getExpression();
        List<Path> selectedPathList = queryExpression.getSelectedSeries();
        TimeGeneratorImpl timeGenerator = new TimeGeneratorImpl(expression, this.chunkLoader, this.metadataQuerier);
        List<Boolean> cached = this.removeFilteredPaths(expression, selectedPathList);
        ArrayList<FileSeriesReaderByTimestamp> readersOfSelectedSeries = new ArrayList<FileSeriesReaderByTimestamp>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        Iterator<Boolean> cachedIterator = cached.iterator();
        Iterator<Path> selectedPathIterator = selectedPathList.iterator();
        while (cachedIterator.hasNext()) {
            boolean cachedValue = cachedIterator.next();
            Path selectedPath = selectedPathIterator.next();
            List<ChunkMetaData> chunkMetaDataList = this.metadataQuerier.getChunkMetaDataList(selectedPath);
            if (chunkMetaDataList.size() != 0) {
                dataTypes.add(chunkMetaDataList.get(0).getTsDataType());
                if (cachedValue) {
                    readersOfSelectedSeries.add(null);
                    continue;
                }
                FileSeriesReaderByTimestamp seriesReader = new FileSeriesReaderByTimestamp(this.chunkLoader, chunkMetaDataList);
                readersOfSelectedSeries.add(seriesReader);
                continue;
            }
            selectedPathIterator.remove();
            cachedIterator.remove();
        }
        return new DataSetWithTimeGenerator(selectedPathList, cached, dataTypes, timeGenerator, readersOfSelectedSeries);
    }

    private List<Boolean> removeFilteredPaths(IExpression expression, List<Path> selectedPaths) {
        ArrayList<Boolean> cached = new ArrayList<Boolean>();
        HashSet<Path> filteredPaths = new HashSet<Path>();
        this.getAllFilteredPaths(expression, filteredPaths);
        for (Path selectedPath : selectedPaths) {
            cached.add(filteredPaths.contains(selectedPath));
        }
        return cached;
    }

    private void getAllFilteredPaths(IExpression expression, HashSet<Path> paths) {
        if (expression instanceof BinaryExpression) {
            this.getAllFilteredPaths(((BinaryExpression)expression).getLeft(), paths);
            this.getAllFilteredPaths(((BinaryExpression)expression).getRight(), paths);
        } else if (expression instanceof SingleSeriesExpression) {
            paths.add(((SingleSeriesExpression)expression).getSeriesPath());
        }
    }
}

