/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class PageReader {
    private TSDataType dataType;
    private Decoder valueDecoder;
    private Decoder timeDecoder;
    private ByteBuffer timeBuffer;
    private ByteBuffer valueBuffer;
    private BatchData data = null;
    private Filter filter = null;
    private long deletedAt = Long.MIN_VALUE;

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter filter) {
        this(pageData, dataType, valueDecoder, timeDecoder);
        this.filter = filter;
    }

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.splitDataToTimeStampAndValue(pageData);
    }

    private void splitDataToTimeStampAndValue(ByteBuffer pageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(pageData);
        this.timeBuffer = pageData.slice();
        this.timeBuffer.limit(timeBufferLength);
        this.valueBuffer = pageData.slice();
        this.valueBuffer.position(timeBufferLength);
    }

    public boolean hasNextBatch() throws IOException {
        return this.timeDecoder.hasNext(this.timeBuffer);
    }

    public BatchData nextBatch() throws IOException {
        this.data = this.filter == null ? this.getAllPageData() : this.getAllPageDataWithFilter();
        return this.data;
    }

    public BatchData currentBatch() {
        return this.data;
    }

    private BatchData getAllPageData() throws IOException {
        BatchData pageData = new BatchData(this.dataType, true);
        block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putBoolean(aBoolean);
                    continue block8;
                }
                case INT32: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putInt(anInt);
                    continue block8;
                }
                case INT64: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putLong(aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putFloat(aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putDouble(aDouble);
                    continue block8;
                }
                case TEXT: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (timestamp <= this.deletedAt) continue block8;
                    pageData.putTime(timestamp);
                    pageData.putBinary(aBinary);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
        }
        return pageData;
    }

    private BatchData getAllPageDataWithFilter() throws IOException {
        BatchData pageData = new BatchData(this.dataType, true);
        block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case BOOLEAN: {
                    this.readBoolean(pageData, timestamp);
                    continue block8;
                }
                case INT32: {
                    this.readInt(pageData, timestamp);
                    continue block8;
                }
                case INT64: {
                    this.readLong(pageData, timestamp);
                    continue block8;
                }
                case FLOAT: {
                    this.readFloat(pageData, timestamp);
                    continue block8;
                }
                case DOUBLE: {
                    this.readDouble(pageData, timestamp);
                    continue block8;
                }
                case TEXT: {
                    this.readText(pageData, timestamp);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
        }
        return pageData;
    }

    private void readBoolean(BatchData pageData, long timestamp) {
        boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, aBoolean)) {
            pageData.putTime(timestamp);
            pageData.putBoolean(aBoolean);
        }
    }

    private void readInt(BatchData pageData, long timestamp) {
        int anInt = this.valueDecoder.readInt(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, anInt)) {
            pageData.putTime(timestamp);
            pageData.putInt(anInt);
        }
    }

    private void readLong(BatchData pageData, long timestamp) {
        long aLong = this.valueDecoder.readLong(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, aLong)) {
            pageData.putTime(timestamp);
            pageData.putLong(aLong);
        }
    }

    private void readFloat(BatchData pageData, long timestamp) {
        float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, Float.valueOf(aFloat))) {
            pageData.putTime(timestamp);
            pageData.putFloat(aFloat);
        }
    }

    private void readDouble(BatchData pageData, long timestamp) {
        double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, aDouble)) {
            pageData.putTime(timestamp);
            pageData.putDouble(aDouble);
        }
    }

    private void readText(BatchData pageData, long timestamp) {
        Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
        if (timestamp > this.deletedAt && this.filter.satisfy(timestamp, aBinary)) {
            pageData.putTime(timestamp);
            pageData.putBinary(aBinary);
        }
    }

    public void close() {
        this.timeBuffer = null;
        this.valueBuffer = null;
    }

    public void setDeletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
    }
}

