/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.record.RowBatch;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Schema {
    private Map<String, MeasurementSchema> measurementSchemaMap = new LinkedHashMap<String, MeasurementSchema>();

    public Schema() {
    }

    public Schema(Map<String, MeasurementSchema> measurements) {
        this();
        this.registerMeasurements(measurements);
    }

    public Schema(List<MeasurementSchema> measurements) {
        this();
        this.registerMeasurements(measurements);
    }

    public Schema(MeasurementSchema[] measurements) {
        this();
        this.registerMeasurements(measurements);
    }

    public RowBatch createRowBatch(String deviceId) {
        return new RowBatch(deviceId, new ArrayList<MeasurementSchema>(this.measurementSchemaMap.values()));
    }

    public RowBatch createRowBatch(String deviceId, int maxBatchSize) {
        return new RowBatch(deviceId, new ArrayList<MeasurementSchema>(this.measurementSchemaMap.values()), maxBatchSize);
    }

    public TSDataType getMeasurementDataType(String measurementId) {
        MeasurementSchema measurement = this.measurementSchemaMap.get(measurementId);
        if (measurement == null) {
            return null;
        }
        return measurement.getType();
    }

    public MeasurementSchema getMeasurementSchema(String measurementId) {
        return this.measurementSchemaMap.get(measurementId);
    }

    public Map<String, MeasurementSchema> getMeasurementSchemaMap() {
        return this.measurementSchemaMap;
    }

    public void registerMeasurement(MeasurementSchema descriptor) {
        this.measurementSchemaMap.put(descriptor.getMeasurementId(), descriptor);
    }

    public void registerMeasurements(Map<String, MeasurementSchema> measurements) {
        measurements.forEach((id, md) -> this.registerMeasurement((MeasurementSchema)md));
    }

    public void registerMeasurements(List<MeasurementSchema> measurements) {
        measurements.forEach(this::registerMeasurement);
    }

    public void registerMeasurements(MeasurementSchema[] measurements) {
        for (MeasurementSchema measurement : measurements) {
            this.registerMeasurement(measurement);
        }
    }

    public boolean hasMeasurement(String measurementId) {
        return this.measurementSchemaMap.containsKey(measurementId);
    }
}

