/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsDigest {
    private ByteBuffer[] statistics;
    private int validSizeOfArray = 0;
    private int serializedSize = 4;

    public static int getNullDigestSize() {
        return 4;
    }

    public static int serializeNullTo(OutputStream outputStream) throws IOException {
        return ReadWriteIOUtils.write(0, outputStream);
    }

    public static int serializeNullTo(ByteBuffer buffer) {
        return ReadWriteIOUtils.write(0, buffer);
    }

    public static TsDigest deserializeFrom(InputStream inputStream) throws IOException {
        TsDigest digest;
        block18: {
            int size;
            digest = new TsDigest();
            digest.validSizeOfArray = size = ReadWriteIOUtils.readInt(inputStream);
            digest.serializedSize = 4;
            if (size <= 0) break block18;
            digest.statistics = new ByteBuffer[StatisticType.getTotalTypeNum()];
            String key = "";
            if (TSFileDescriptor.getInstance().getConfig().getEndian().equals("LITTLE_ENDIAN")) {
                for (int i = 0; i < size; ++i) {
                    key = ReadWriteIOUtils.readString(inputStream);
                    ByteBuffer value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(inputStream);
                    switch (key) {
                        case "min_value": {
                            int n = 0;
                            break;
                        }
                        case "max_value": {
                            int n = 1;
                            break;
                        }
                        case "first": {
                            int n = 2;
                            break;
                        }
                        case "last": {
                            int n = 3;
                            break;
                        }
                        case "sum": {
                            int n = 4;
                            break;
                        }
                        default: {
                            int n = -1;
                        }
                    }
                    digest.statistics[n] = value;
                    digest.serializedSize += 6 + value.remaining();
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    ByteBuffer value;
                    short n = ReadWriteIOUtils.readShort(inputStream);
                    digest.statistics[n] = value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(inputStream);
                    digest.serializedSize += 6 + value.remaining();
                }
            }
        }
        return digest;
    }

    public static TsDigest deserializeFrom(ByteBuffer buffer) {
        TsDigest digest;
        block18: {
            int size;
            digest = new TsDigest();
            digest.validSizeOfArray = size = ReadWriteIOUtils.readInt(buffer);
            digest.serializedSize = 4;
            if (size <= 0) break block18;
            digest.statistics = new ByteBuffer[StatisticType.getTotalTypeNum()];
            buffer.mark();
            String key = ReadWriteIOUtils.readString(buffer);
            if (key.equals("min_value") || key.equals("max_value") || key.equals("first") || key.equals("last") || key.equals("sum")) {
                buffer.reset();
                for (int i = 0; i < size; ++i) {
                    key = ReadWriteIOUtils.readString(buffer);
                    ByteBuffer value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
                    switch (key) {
                        case "min_value": {
                            int n = 0;
                            break;
                        }
                        case "max_value": {
                            int n = 1;
                            break;
                        }
                        case "first": {
                            int n = 2;
                            break;
                        }
                        case "last": {
                            int n = 3;
                            break;
                        }
                        case "sum": {
                            int n = 4;
                            break;
                        }
                        default: {
                            int n = -1;
                        }
                    }
                    digest.statistics[n] = value;
                    digest.serializedSize += 6 + value.remaining();
                }
            } else {
                buffer.reset();
                for (int i = 0; i < size; ++i) {
                    ByteBuffer value;
                    short n = ReadWriteIOUtils.readShort(buffer);
                    digest.statistics[n] = value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
                    digest.serializedSize += 6 + value.remaining();
                }
            }
        }
        return digest;
    }

    private void reCalculate() {
        this.validSizeOfArray = 0;
        this.serializedSize = 4;
        if (this.statistics != null) {
            for (ByteBuffer value : this.statistics) {
                if (value == null) continue;
                this.serializedSize += 6 + value.remaining();
                ++this.validSizeOfArray;
            }
        }
    }

    public ByteBuffer[] getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ByteBuffer[] statistics) throws IOException {
        if (statistics != null && statistics.length != StatisticType.getTotalTypeNum()) {
            throw new IOException(String.format("The length of array of statistics doesn't equal StatisticType.getTotalTypeNum() %d", StatisticType.getTotalTypeNum()));
        }
        this.statistics = statistics;
        this.reCalculate();
    }

    public String toString() {
        return this.statistics != null ? Arrays.toString(this.statistics) : "";
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        if (this.validSizeOfArray == 0) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.validSizeOfArray, outputStream);
            for (int i = 0; i < this.statistics.length; ++i) {
                if (this.statistics[i] == null) continue;
                byteLen += ReadWriteIOUtils.write((short)i, outputStream);
                byteLen += ReadWriteIOUtils.write(this.statistics[i], outputStream);
            }
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        if (this.validSizeOfArray == 0) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.validSizeOfArray, buffer);
            for (int i = 0; i < this.statistics.length; ++i) {
                if (this.statistics[i] == null) continue;
                byteLen += ReadWriteIOUtils.write((short)i, buffer);
                byteLen += ReadWriteIOUtils.write(this.statistics[i], buffer);
            }
        }
        return byteLen;
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsDigest digest = (TsDigest)o;
        if (this.serializedSize != digest.serializedSize || this.validSizeOfArray != digest.validSizeOfArray || this.statistics == null ^ digest.statistics == null) {
            return false;
        }
        if (this.statistics != null) {
            for (int i = 0; i < this.statistics.length; ++i) {
                if (this.statistics[i] == null ^ digest.statistics[i] == null) {
                    return false;
                }
                if (this.statistics[i] == null || this.statistics[i].equals(digest.statistics[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static enum StatisticType {
        min_value,
        max_value,
        first_value,
        last_value,
        sum_value;


        public static int getTotalTypeNum() {
            return StatisticType.values().length;
        }

        public static StatisticType deserialize(short i) {
            return StatisticType.values()[i];
        }

        public static int getSerializedSize() {
            return 2;
        }

        public short serialize() {
            return (short)this.ordinal();
        }
    }
}

