/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DoubleStatistics
extends Statistics<Double> {
    private double min;
    private double max;
    private double first;
    private double last;
    private double sum;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.min = BytesUtils.bytesToDouble(minBytes);
        this.max = BytesUtils.bytesToDouble(maxBytes);
    }

    @Override
    public void updateStats(double value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
        }
    }

    @Override
    public void updateStats(double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (this.isEmpty) {
                this.initializeStats(values[i], values[i], values[i], values[i], values[i]);
                this.isEmpty = false;
                continue;
            }
            this.updateStats(values[i], values[i], values[i], values[i], values[i]);
        }
    }

    private void updateStats(double minValue, double maxValue, double firstValue, double lastValue, double sumValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = lastValue;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public Double getFirst() {
        return this.first;
    }

    @Override
    public Double getLast() {
        return this.last;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        DoubleStatistics doubleStats = (DoubleStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(doubleStats.getMin(), doubleStats.getMax(), doubleStats.getFirst(), doubleStats.getLast(), doubleStats.getSum());
            this.isEmpty = false;
        } else {
            this.updateStats(doubleStats.getMin(), doubleStats.getMax(), doubleStats.getFirst(), doubleStats.getLast(), doubleStats.getSum());
        }
    }

    private void initializeStats(double min, double max, double first, double last, double sum) {
        this.min = min;
        this.max = max;
        this.first = first;
        this.last = last;
        this.sum = sum;
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.doubleToBytes(this.min);
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.doubleToBytes(this.max);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.doubleToBytes(this.first);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.doubleToBytes(this.last);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public int sizeOfDatum() {
        return 8;
    }

    public String toString() {
        return "[min:" + this.min + ",max:" + this.max + ",first:" + this.first + ",last:" + this.last + ",sum:" + this.sum + "]";
    }

    @Override
    void deserialize(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readDouble(inputStream);
        this.max = ReadWriteIOUtils.readDouble(inputStream);
        this.first = ReadWriteIOUtils.readDouble(inputStream);
        this.last = ReadWriteIOUtils.readDouble(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readDouble(byteBuffer);
        this.max = ReadWriteIOUtils.readDouble(byteBuffer);
        this.first = ReadWriteIOUtils.readDouble(byteBuffer);
        this.last = ReadWriteIOUtils.readDouble(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

