/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.write.UnknownColumnTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BinaryStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.DoubleStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.FloatStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.StatisticsClassException;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Statistics<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Statistics.class);
    protected boolean isEmpty = true;

    public static Statistics<?> getStatsByType(TSDataType type) {
        switch (type) {
            case INT32: {
                return new IntegerStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case TEXT: {
                return new BinaryStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
        }
        throw new UnknownColumnTypeException(type.toString());
    }

    public static Statistics deserialize(InputStream inputStream, TSDataType dataType) throws IOException {
        Statistics<?> statistics = Statistics.getStatsByType(dataType);
        statistics.deserialize(inputStream);
        statistics.isEmpty = false;
        return statistics;
    }

    public static Statistics deserialize(ByteBuffer buffer, TSDataType dataType) throws IOException {
        Statistics<?> statistics = Statistics.getStatsByType(dataType);
        statistics.deserialize(buffer);
        statistics.isEmpty = false;
        return statistics;
    }

    public static Statistics deserialize(TsFileInput input, long offset, TSDataType dataType) throws IOException {
        Statistics<?> statistics = Statistics.getStatsByType(dataType);
        statistics.deserialize(input, offset);
        statistics.isEmpty = false;
        return statistics;
    }

    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract T getMin();

    public abstract T getMax();

    public abstract T getFirst();

    public abstract T getLast();

    public abstract double getSum();

    public abstract byte[] getMinBytes();

    public abstract byte[] getMaxBytes();

    public abstract byte[] getFirstBytes();

    public abstract byte[] getLastBytes();

    public abstract byte[] getSumBytes();

    public abstract ByteBuffer getMinBytebuffer();

    public abstract ByteBuffer getMaxBytebuffer();

    public abstract ByteBuffer getFirstBytebuffer();

    public abstract ByteBuffer getLastBytebuffer();

    public abstract ByteBuffer getSumBytebuffer();

    public void mergeStatistics(Statistics<?> stats) {
        if (stats == null) {
            LOG.warn("tsfile-file parameter stats is null");
            return;
        }
        if (this.getClass() == stats.getClass()) {
            if (!stats.isEmpty) {
                this.mergeStatisticsValue(stats);
                this.isEmpty = false;
            }
        } else {
            String thisClass = this.getClass().toString();
            String statsClass = stats.getClass().toString();
            LOG.warn("tsfile-file Statistics classes mismatched,no merge: {} v.s. {}", (Object)thisClass, (Object)statsClass);
            throw new StatisticsClassException(this.getClass(), stats.getClass());
        }
    }

    protected abstract void mergeStatisticsValue(Statistics<?> var1);

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    public void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long min, long max) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(boolean[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(int[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary[] values, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
    }

    public abstract int sizeOfDatum();

    abstract void deserialize(InputStream var1) throws IOException;

    abstract void deserialize(ByteBuffer var1) throws IOException;

    protected void deserialize(TsFileInput input, long offset) throws IOException {
        int size = this.getSerializedSize();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ReadWriteIOUtils.readAsPossible(input, offset, buffer);
        buffer.flip();
        this.deserialize(buffer);
    }

    public int getSerializedSize() {
        if (this.sizeOfDatum() == 0) {
            return 0;
        }
        if (this.sizeOfDatum() != -1) {
            return this.sizeOfDatum() * 4 + 8;
        }
        return 16 + this.getMinBytes().length + this.getMaxBytes().length + this.getFirstBytes().length + this.getLastBytes().length + this.getSumBytes().length;
    }

    public int serialize(OutputStream outputStream) throws IOException {
        int length = 0;
        if (this.sizeOfDatum() == 0) {
            return 0;
        }
        if (this.sizeOfDatum() != -1) {
            length = this.sizeOfDatum() * 4 + 8;
            outputStream.write(this.getMinBytes());
            outputStream.write(this.getMaxBytes());
            outputStream.write(this.getFirstBytes());
            outputStream.write(this.getLastBytes());
            outputStream.write(this.getSumBytes());
        } else {
            byte[] tmp = this.getMinBytes();
            length += tmp.length;
            length += ReadWriteIOUtils.write(tmp.length, outputStream);
            outputStream.write(tmp);
            tmp = this.getMaxBytes();
            length += tmp.length;
            length += ReadWriteIOUtils.write(tmp.length, outputStream);
            outputStream.write(tmp);
            tmp = this.getFirstBytes();
            length += tmp.length;
            length += ReadWriteIOUtils.write(tmp.length, outputStream);
            outputStream.write(tmp);
            tmp = this.getLastBytes();
            length += tmp.length;
            length += ReadWriteIOUtils.write(tmp.length, outputStream);
            outputStream.write(tmp);
            outputStream.write(this.getSumBytes());
            length += 8;
        }
        return length;
    }
}

