/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.NodeType;

public class AndNode
implements Node {
    private Node leftChild;
    private Node rightChild;
    private long cachedValue;
    private boolean hasCachedValue;

    public AndNode(Node leftChild, Node rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedValue = false;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCachedValue) {
            return true;
        }
        if (this.leftChild.hasNext() && this.rightChild.hasNext()) {
            long leftValue = this.leftChild.next();
            long rightValue = this.rightChild.next();
            while (true) {
                if (leftValue == rightValue) {
                    this.hasCachedValue = true;
                    this.cachedValue = leftValue;
                    return true;
                }
                if (leftValue > rightValue) {
                    if (this.rightChild.hasNext()) {
                        rightValue = this.rightChild.next();
                        continue;
                    }
                    return false;
                }
                if (!this.leftChild.hasNext()) break;
                leftValue = this.leftChild.next();
            }
            return false;
        }
        return false;
    }

    @Override
    public long next() throws IOException {
        if (this.hasNext()) {
            this.hasCachedValue = false;
            return this.cachedValue;
        }
        return -1L;
    }

    @Override
    public NodeType getType() {
        return NodeType.AND;
    }
}

