/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.DigestForFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;

public class FileSeriesReaderWithFilter
extends FileSeriesReader {
    private Filter filter;

    public FileSeriesReaderWithFilter(IChunkLoader chunkLoader, List<ChunkMetaData> chunkMetaDataList, Filter filter) {
        super(chunkLoader, chunkMetaDataList);
        this.filter = filter;
    }

    @Override
    protected void initChunkReader(ChunkMetaData chunkMetaData) throws IOException {
        Chunk chunk = this.chunkLoader.getChunk(chunkMetaData);
        this.chunkReader = new ChunkReaderWithFilter(chunk, this.filter);
    }

    @Override
    protected boolean chunkSatisfied(ChunkMetaData chunkMetaData) {
        ByteBuffer minValue = null;
        ByteBuffer maxValue = null;
        ByteBuffer[] statistics = chunkMetaData.getDigest().getStatistics();
        if (statistics != null) {
            minValue = statistics[TsDigest.StatisticType.min_value.ordinal()];
            maxValue = statistics[TsDigest.StatisticType.max_value.ordinal()];
        }
        DigestForFilter digest = new DigestForFilter(chunkMetaData.getStartTime(), chunkMetaData.getEndTime(), minValue, maxValue, chunkMetaData.getTsDataType());
        return this.filter.satisfy(digest);
    }
}

