/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.record;

import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class RowBatch {
    private static final int DEFAULT_SIZE = 1024;
    public String deviceId;
    public List<MeasurementSchema> measurements;
    public long[] timestamps;
    public Object[] values;
    public int batchSize;
    private int maxBatchSize;
    private int valueOccupation = -1;

    public RowBatch(String deviceId, List<MeasurementSchema> measurements) {
        this(deviceId, measurements, 1024);
    }

    public RowBatch(String deviceId, List<MeasurementSchema> measurements, int maxBatchSize) {
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.maxBatchSize = maxBatchSize;
        this.createColumns();
        this.reset();
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void reset() {
        this.batchSize = 0;
    }

    private void createColumns() {
        this.timestamps = new long[this.maxBatchSize];
        this.values = new Object[this.measurements.size()];
        block8: for (int i = 0; i < this.measurements.size(); ++i) {
            TSDataType dataType = this.measurements.get(i).getType();
            switch (dataType) {
                case INT32: {
                    this.values[i] = new int[this.maxBatchSize];
                    continue block8;
                }
                case INT64: {
                    this.values[i] = new long[this.maxBatchSize];
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = new float[this.maxBatchSize];
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = new double[this.maxBatchSize];
                    continue block8;
                }
                case BOOLEAN: {
                    this.values[i] = new boolean[this.maxBatchSize];
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = new Binary[this.maxBatchSize];
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
                }
            }
        }
    }

    public int getTimeBytesSize() {
        return this.batchSize * 8;
    }

    public int getValueBytesSize() {
        this.valueOccupation = 0;
        block8: for (int i = 0; i < this.measurements.size(); ++i) {
            switch (this.measurements.get(i).getType()) {
                case BOOLEAN: {
                    this.valueOccupation += this.batchSize;
                    continue block8;
                }
                case INT32: {
                    this.valueOccupation += this.batchSize * 4;
                    continue block8;
                }
                case INT64: {
                    this.valueOccupation += this.batchSize * 8;
                    continue block8;
                }
                case FLOAT: {
                    this.valueOccupation += this.batchSize * 4;
                    continue block8;
                }
                case DOUBLE: {
                    this.valueOccupation += this.batchSize * 8;
                    continue block8;
                }
                case TEXT: {
                    this.valueOccupation += this.batchSize * 4;
                    for (Binary value : (Binary[])this.values[i]) {
                        this.valueOccupation += value.getLength();
                    }
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{this.measurements.get(i).getType()}));
                }
            }
        }
        return this.valueOccupation;
    }
}

