/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.DefaultTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileIOWriter {
    public static final byte[] magicStringBytes;
    public static final byte[] versionNumberBytes;
    protected static final TSFileConfig config;
    private static final Logger logger;
    protected TsFileOutput out;
    protected List<ChunkGroupMetaData> chunkGroupMetaDataList = new ArrayList<ChunkGroupMetaData>();
    protected boolean canWrite = true;
    protected int totalChunkNum = 0;
    protected int invalidChunkNum;
    protected File file;
    private ChunkGroupMetaData currentChunkGroupMetaData;
    private ChunkMetaData currentChunkMetaData;
    private long markedPosition;

    protected TsFileIOWriter() {
    }

    public TsFileIOWriter(File file) throws IOException {
        this.out = new DefaultTsFileOutput(file);
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output) throws IOException {
        this.out = output;
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput out, List<ChunkGroupMetaData> chunkGroupMetaDataList) throws IOException {
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(this.file.getPath(), false);
        this.chunkGroupMetaDataList = chunkGroupMetaDataList;
        if (chunkGroupMetaDataList.isEmpty()) {
            this.startFile();
        }
    }

    public void writeBytesToStream(PublicBAOS bytes) throws IOException {
        bytes.writeTo(this.out.wrapAsStream());
    }

    protected void startFile() throws IOException {
        this.out.write(magicStringBytes);
        this.out.write(versionNumberBytes);
    }

    public void startChunkGroup(String deviceId) throws IOException {
        logger.debug("start chunk group:{}, file position {}", (Object)deviceId, (Object)this.out.getPosition());
        this.currentChunkGroupMetaData = new ChunkGroupMetaData(deviceId, new ArrayList<ChunkMetaData>(), this.out.getPosition());
    }

    public void endChunkGroup(long version) throws IOException {
        if (this.currentChunkGroupMetaData == null || this.currentChunkGroupMetaData.getChunkMetaDataList().isEmpty()) {
            return;
        }
        long dataSize = this.out.getPosition() - this.currentChunkGroupMetaData.getStartOffsetOfChunkGroup();
        ChunkGroupFooter chunkGroupFooter = new ChunkGroupFooter(this.currentChunkGroupMetaData.getDeviceID(), dataSize, this.currentChunkGroupMetaData.getChunkMetaDataList().size());
        chunkGroupFooter.serializeTo(this.out.wrapAsStream());
        this.currentChunkGroupMetaData.setEndOffsetOfChunkGroup(this.out.getPosition());
        this.currentChunkGroupMetaData.setVersion(version);
        this.chunkGroupMetaDataList.add(this.currentChunkGroupMetaData);
        logger.debug("end chunk group:{}", (Object)this.currentChunkGroupMetaData);
        this.currentChunkGroupMetaData = null;
    }

    public int startFlushChunk(MeasurementSchema descriptor, CompressionType compressionCodecName, TSDataType tsDataType, TSEncoding encodingType, Statistics<?> statistics, long maxTime, long minTime, int dataSize, int numOfPages) throws IOException {
        this.currentChunkMetaData = new ChunkMetaData(descriptor.getMeasurementId(), tsDataType, this.out.getPosition(), minTime, maxTime);
        if (logger.isDebugEnabled()) {
            logger.debug("start series chunk:{}, file position {}", (Object)descriptor, (Object)this.out.getPosition());
        }
        ChunkHeader header = new ChunkHeader(descriptor.getMeasurementId(), dataSize, tsDataType, compressionCodecName, encodingType, numOfPages);
        header.serializeTo(this.out.wrapAsStream());
        if (logger.isDebugEnabled()) {
            logger.debug("finish series chunk:{} header, file position {}", (Object)header, (Object)this.out.getPosition());
        }
        ByteBuffer[] statisticsArray = new ByteBuffer[TsDigest.StatisticType.getTotalTypeNum()];
        statisticsArray[TsDigest.StatisticType.max_value.ordinal()] = ByteBuffer.wrap(statistics.getMaxBytes());
        statisticsArray[TsDigest.StatisticType.min_value.ordinal()] = ByteBuffer.wrap(statistics.getMinBytes());
        statisticsArray[TsDigest.StatisticType.first_value.ordinal()] = ByteBuffer.wrap(statistics.getFirstBytes());
        statisticsArray[TsDigest.StatisticType.last_value.ordinal()] = ByteBuffer.wrap(statistics.getLastBytes());
        statisticsArray[TsDigest.StatisticType.sum_value.ordinal()] = ByteBuffer.wrap(statistics.getSumBytes());
        TsDigest tsDigest = new TsDigest();
        tsDigest.setStatistics(statisticsArray);
        this.currentChunkMetaData.setDigest(tsDigest);
        return header.getSerializedSize();
    }

    public void writeChunk(Chunk chunk, ChunkMetaData chunkMetadata) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetaData = new ChunkMetaData(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunkMetadata.getStartTime(), chunkMetadata.getEndTime());
        this.currentChunkMetaData.setDigest(chunkMetadata.getDigest());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endChunk(chunkMetadata.getNumOfPoints());
    }

    public void endChunk(long totalValueCount) {
        this.currentChunkMetaData.setNumOfPoints(totalValueCount);
        this.currentChunkGroupMetaData.addTimeSeriesChunkMetaData(this.currentChunkMetaData);
        logger.debug("end series chunk:{},totalvalue:{}", (Object)this.currentChunkMetaData, (Object)totalValueCount);
        this.currentChunkMetaData = null;
        ++this.totalChunkNum;
    }

    public void endFile(Schema schema) throws IOException {
        ReadWriteIOUtils.write((byte)2, this.out.wrapAsStream());
        Map<String, MeasurementSchema> schemaDescriptors = schema.getMeasurementSchemaMap();
        logger.debug("get time series list:{}", schemaDescriptors);
        Map<String, TsDeviceMetadataIndex> tsDeviceMetadataIndexMap = this.flushTsDeviceMetaDataAndGetIndex(this.chunkGroupMetaDataList);
        TsFileMetaData tsFileMetaData = new TsFileMetaData(tsDeviceMetadataIndexMap, schemaDescriptors);
        tsFileMetaData.setTotalChunkNum(this.totalChunkNum);
        tsFileMetaData.setInvalidChunkNum(this.invalidChunkNum);
        long footerIndex = this.out.getPosition();
        logger.debug("start to flush the footer,file pos:{}", (Object)footerIndex);
        int size = tsFileMetaData.serializeTo(this.out.wrapAsStream());
        if (logger.isDebugEnabled()) {
            logger.debug("finish flushing the footer {}, file pos:{}", (Object)tsFileMetaData, (Object)this.out.getPosition());
        }
        size += tsFileMetaData.serializeBloomFilter(this.out.wrapAsStream(), this.chunkGroupMetaDataList);
        if (logger.isDebugEnabled()) {
            logger.debug("finish flushing the bloom filter file pos:{}", (Object)this.out.getPosition());
        }
        ReadWriteIOUtils.write(size, this.out.wrapAsStream());
        this.out.write(magicStringBytes);
        this.out.close();
        this.canWrite = false;
        logger.info("output stream is closed");
    }

    private Map<String, TsDeviceMetadataIndex> flushTsDeviceMetaDataAndGetIndex(List<ChunkGroupMetaData> chunkGroupMetaDataList) throws IOException {
        HashMap<String, TsDeviceMetadataIndex> tsDeviceMetadataIndexMap = new HashMap<String, TsDeviceMetadataIndex>();
        for (Map.Entry<String, TsDeviceMetadata> entry : this.getAllTsDeviceMetadata(chunkGroupMetaDataList).entrySet()) {
            TsDeviceMetadata currentTsDeviceMetadata = entry.getValue();
            long offset = this.out.getPosition();
            int size = currentTsDeviceMetadata.serializeTo(this.out.wrapAsStream());
            TsDeviceMetadataIndex tsDeviceMetadataIndex = new TsDeviceMetadataIndex(offset, size, currentTsDeviceMetadata);
            tsDeviceMetadataIndexMap.put(entry.getKey(), tsDeviceMetadataIndex);
        }
        return tsDeviceMetadataIndexMap;
    }

    private TreeMap<String, TsDeviceMetadata> getAllTsDeviceMetadata(List<ChunkGroupMetaData> chunkGroupMetaDataList) {
        TreeMap<String, TsDeviceMetadata> tsDeviceMetadataMap = new TreeMap<String, TsDeviceMetadata>();
        for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
            String currentDevice = chunkGroupMetaData.getDeviceID();
            if (!tsDeviceMetadataMap.containsKey(currentDevice)) {
                TsDeviceMetadata tsDeviceMetadata = new TsDeviceMetadata();
                tsDeviceMetadataMap.put(currentDevice, tsDeviceMetadata);
            }
            tsDeviceMetadataMap.get(currentDevice).addChunkGroupMetaData(chunkGroupMetaData);
        }
        return tsDeviceMetadataMap;
    }

    public long getPos() throws IOException {
        return this.out.getPosition();
    }

    public List<ChunkGroupMetaData> getChunkGroupMetaDatas() {
        return this.chunkGroupMetaDataList;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void mark() throws IOException {
        this.markedPosition = this.getPos();
    }

    public void reset() throws IOException {
        this.out.truncate(this.markedPosition);
    }

    public void close() throws IOException {
        this.canWrite = false;
        this.out.close();
    }

    void writeSeparatorMaskForTest() throws IOException {
        this.out.write(new byte[]{2});
    }

    void writeChunkMaskForTest() throws IOException {
        this.out.write(new byte[]{1});
    }

    public Map<String, MeasurementSchema> getKnownSchema() {
        return Collections.emptyMap();
    }

    public int getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public int getInvalidChunkNum() {
        return this.invalidChunkNum;
    }

    public File getFile() {
        return this.file;
    }

    public void filterChunks(Map<Path, List<Long>> chunkStartTimes) {
        HashMap<Path, Integer> startTimeIdxes = new HashMap<Path, Integer>();
        chunkStartTimes.forEach((p, t) -> startTimeIdxes.put((Path)p, 0));
        Iterator<ChunkGroupMetaData> chunkGroupMetaDataIterator = this.chunkGroupMetaDataList.iterator();
        while (chunkGroupMetaDataIterator.hasNext()) {
            ChunkGroupMetaData chunkGroupMetaData = chunkGroupMetaDataIterator.next();
            String deviceId = chunkGroupMetaData.getDeviceID();
            int chunkNum = chunkGroupMetaData.getChunkMetaDataList().size();
            Iterator<ChunkMetaData> chunkMetaDataIterator = chunkGroupMetaData.getChunkMetaDataList().iterator();
            while (chunkMetaDataIterator.hasNext()) {
                List<Long> pathChunkStartTimes;
                boolean chunkValid;
                ChunkMetaData chunkMetaData = chunkMetaDataIterator.next();
                Path path = new Path(deviceId, chunkMetaData.getMeasurementUid());
                int startTimeIdx = (Integer)startTimeIdxes.get(path);
                boolean bl = chunkValid = startTimeIdx < (pathChunkStartTimes = chunkStartTimes.get(path)).size() && pathChunkStartTimes.get(startTimeIdx).longValue() == chunkMetaData.getStartTime();
                if (!chunkValid) {
                    chunkMetaDataIterator.remove();
                    --chunkNum;
                    ++this.invalidChunkNum;
                    continue;
                }
                startTimeIdxes.put(path, startTimeIdx + 1);
            }
            if (chunkNum != 0) continue;
            chunkGroupMetaDataIterator.remove();
        }
    }

    public TsFileOutput getIOWriterOut() {
        return this.out;
    }

    static {
        config = TSFileDescriptor.getInstance().getConfig();
        logger = LoggerFactory.getLogger(TsFileIOWriter.class);
        magicStringBytes = BytesUtils.stringToBytes("TsFile");
        versionNumberBytes = "000001".getBytes();
    }
}

