/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class IntegerStatistics
extends Statistics<Integer> {
    private int minValue;
    private int maxValue;
    private int firstValue;
    private int lastValue;
    private long sumValue;
    static final int INTEGER_STATISTICS_FIXED_RAM_SIZE = 64;

    @Override
    public TSDataType getType() {
        return TSDataType.INT32;
    }

    @Override
    public int getStatsSize() {
        return 24;
    }

    public void initializeStats(int min, int max, int first, int last, long sum) {
        this.minValue = min;
        this.maxValue = max;
        this.firstValue = first;
        this.lastValue = last;
        this.sumValue = sum;
    }

    private void updateStats(int minValue, int maxValue, int lastValue, long sumValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        this.lastValue = lastValue;
    }

    private void updateStats(int minValue, int maxValue, int firstValue, int lastValue, long sumValue, long startTime, long endTime) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    void updateStats(int value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value);
        }
    }

    @Override
    void updateStats(int[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public long calculateRamSize() {
        return 64L;
    }

    @Override
    public Integer getMinValue() {
        return this.minValue;
    }

    @Override
    public Integer getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Integer getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Integer getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.INT32, "double sum"));
    }

    @Override
    public long getSumLongValue() {
        return this.sumValue;
    }

    @Override
    protected void mergeStatisticsValue(Statistics<Integer> stats) {
        IntegerStatistics intStats = (IntegerStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(intStats.getMinValue(), intStats.getMaxValue(), intStats.getFirstValue(), intStats.getLastValue(), intStats.sumValue);
            this.isEmpty = false;
        } else {
            this.updateStats(intStats.getMinValue(), intStats.getMaxValue(), intStats.getFirstValue(), intStats.getLastValue(), intStats.sumValue, stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.minValue = ReadWriteIOUtils.readInt(inputStream);
        this.maxValue = ReadWriteIOUtils.readInt(inputStream);
        this.firstValue = ReadWriteIOUtils.readInt(inputStream);
        this.lastValue = ReadWriteIOUtils.readInt(inputStream);
        this.sumValue = ReadWriteIOUtils.readLong(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.minValue = ReadWriteIOUtils.readInt(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readInt(byteBuffer);
        this.firstValue = ReadWriteIOUtils.readInt(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readInt(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readLong(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegerStatistics that = (IntegerStatistics)o;
        return this.minValue == that.minValue && this.maxValue == that.maxValue && this.firstValue == that.firstValue && this.lastValue == that.lastValue && this.sumValue == that.sumValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minValue, this.maxValue, this.firstValue, this.lastValue, this.sumValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [minValue:" + this.minValue + ",maxValue:" + this.maxValue + ",firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + ",sumValue:" + this.sumValue + "]";
    }
}

