/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileInputFactory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.tsfile.fileSystem.FSPath;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.HDFSInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.LocalFSInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.OSFileInputFactory;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridFileInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HybridFileInputFactory.class);
    private static final Map<FSType, FileInputFactory> inputFactories = new ConcurrentHashMap<FSType, FileInputFactory>();

    private FileInputFactory getFileInputFactory(FSType fsType) {
        return inputFactories.compute(fsType, (k, v) -> {
            if (v != null) {
                return v;
            }
            switch (fsType) {
                case LOCAL: {
                    return new LocalFSInputFactory();
                }
                case OBJECT_STORAGE: {
                    return new OSFileInputFactory();
                }
                case HDFS: {
                    return new HDFSInputFactory();
                }
            }
            return null;
        });
    }

    @Override
    public TsFileInput getTsFileInput(String filePath) throws IOException {
        FSPath path = FSUtils.parse(filePath);
        return this.getFileInputFactory(path.getFsType()).getTsFileInput(path.getPath());
    }
}

