/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class FloatColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FloatColumnBuilder.class).instanceSize();
    public static final FloatColumn NULL_VALUE_BLOCK = new FloatColumn(0, 1, new boolean[]{true}, new float[1]);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private float[] values = new float[0];
    private long retainedSizeInBytes;

    public FloatColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public ColumnBuilder writeFloat(float value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(5);
        }
        return this;
    }

    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeFloat(value.getFloat());
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
            return this;
        }
        throw new UnSupportedDataTypeException("FloatColumn only support Float data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeFloat(column.getFloat(index));
    }

    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(5);
        }
        return this;
    }

    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new FloatColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.FLOAT;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new FloatColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((float[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += (long)ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }
}

