/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class PaginationController {
    public static final PaginationController UNLIMITED_PAGINATION_CONTROLLER = new PaginationController(0L, 0L);
    private final boolean hasLimit;
    private long curLimit;
    private long curOffset;

    public PaginationController(long limit, long offset) {
        this.curLimit = limit;
        this.hasLimit = limit > 0L;
        this.curOffset = offset;
    }

    public boolean hasCurOffset() {
        return this.curOffset > 0L;
    }

    public boolean hasCurOffset(long rowCount) {
        return this.curOffset >= rowCount;
    }

    public boolean hasCurLimit() {
        return !this.hasLimit || this.curLimit > 0L;
    }

    public void consumeOffset(long rowCount) {
        this.curOffset -= rowCount;
    }

    public void consumeOffset() {
        --this.curOffset;
    }

    public long getCurOffset() {
        return this.curOffset;
    }

    public long getCurLimit() {
        return this.curLimit;
    }

    public void consumeLimit() {
        if (this.hasLimit) {
            --this.curLimit;
        }
    }

    public void consumeLimit(long rowCount) {
        if (this.hasLimit) {
            this.curLimit -= rowCount;
        }
    }

    public TsBlock applyTsBlock(TsBlock resultTsBlock) {
        int fromIndex = 0;
        int length = resultTsBlock.getPositionCount();
        if (this.hasCurOffset()) {
            fromIndex = (int)Math.min(this.curOffset, (long)length);
            length -= fromIndex;
            this.consumeOffset(fromIndex);
        }
        if (this.hasLimit && this.curLimit > 0L) {
            length = (int)Math.min(this.curLimit, (long)length);
            this.consumeLimit(length);
        }
        return resultTsBlock.getRegion(fromIndex, length);
    }
}

