/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.net.URLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchiveClassPathEntry
extends ClassPathEntry {
    private static final Logger log = LoggerFactory.getLogger((Class)ArchiveClassPathEntry.class);
    private final Property prop;
    private Map entryMap;
    private Manifest jarManifest;
    private boolean jarManifestRead;

    ArchiveClassPathEntry(Property prop, String path) throws RepositoryException {
        super(prop.getSession(), path);
        this.prop = prop;
    }

    protected ArchiveClassPathEntry(ArchiveClassPathEntry base) {
        super(base);
        this.prop = base.prop;
    }

    protected Property getProperty() {
        return this.prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoaderResource getResource(String name) {
        JarInputStream zins = null;
        try {
            zins = ArchiveClassPathEntry.getJarInputStream(this.prop);
            JarEntry entry = this.findEntry(zins, name);
            if (entry != null) {
                ArchiveClassPathResource archiveClassPathResource = new ArchiveClassPathResource(this, entry);
                return archiveClassPathResource;
            }
            log.debug("getResource: resource {} not found in archive {}", (Object)name, (Object)this.path);
        }
        catch (IOException ioe) {
            log.warn("getResource: problem accessing the archive {} for {}", (Object)new Object[]{this.path, name}, (Object)ioe);
        }
        catch (RepositoryException re) {
            log.warn("getResource: problem accessing the archive {} for {}", (Object)new Object[]{this.path, name}, (Object)re);
        }
        finally {
            if (zins != null) {
                try {
                    zins.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    ClassPathEntry copy() {
        return new ArchiveClassPathEntry(this);
    }

    public URL toURL() {
        if (this.baseURL == null) {
            try {
                this.baseURL = URLFactory.createJarURL(this.session, this.path, null);
            }
            catch (MalformedURLException mue) {
                log.warn("Problem creating baseURI for " + this.path, (Throwable)mue);
            }
        }
        return this.baseURL;
    }

    protected URL getURL(String name) {
        try {
            return URLFactory.createJarURL(this.session, this.path, name);
        }
        catch (MalformedURLException mue) {
            log.error("getURL: Cannot create URL for " + name, (Throwable)mue);
            return null;
        }
    }

    protected URL getCodeSourceURL() {
        try {
            return URLFactory.createURL(this.session, this.path);
        }
        catch (MalformedURLException mue) {
            log.warn("getCodeSourceURL: Cannot getURL for " + this.path, (Throwable)mue);
            return null;
        }
    }

    static JarInputStream getJarInputStream(Property property) throws RepositoryException, IOException {
        return new JarInputStream(property.getStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Manifest getManifest() {
        if (this.jarManifest == null && !this.jarManifestRead) {
            this.jarManifestRead = true;
            JarInputStream zipIns = null;
            try {
                zipIns = new JarInputStream(this.prop.getStream());
                this.jarManifest = zipIns.getManifest();
            }
            catch (RepositoryException re) {
                log.warn("Cannot access JAR file " + this.getPath(), (Throwable)re);
            }
            catch (IOException ioe) {
                log.warn("Cannot access manifest of JAR file " + this.getPath(), (Throwable)ioe);
            }
            finally {
                if (zipIns != null) {
                    try {
                        zipIns.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return this.jarManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JarEntry findEntry(JarInputStream zins, String path) throws IOException {
        Number entryNumO;
        if (this.entryMap == null) {
            ArchiveClassPathEntry archiveClassPathEntry = this;
            synchronized (archiveClassPathEntry) {
                if (this.entryMap == null) {
                    HashMap<String, Integer> tmpEntryMap = new HashMap<String, Integer>();
                    try {
                        log.debug("findEntry: Building map while searching");
                        JarEntry result = null;
                        JarEntry entry = zins.getNextJarEntry();
                        int i = 0;
                        while (entry != null) {
                            String name = entry.getName();
                            Integer entryNumO2 = new Integer(i);
                            tmpEntryMap.put(name, entryNumO2);
                            log.debug("findEntry: Entry {} ==> {}", (Object)name, (Object)entryNumO2);
                            if (result == null && path.equals(name)) {
                                log.debug("findEntry: Found the entry, continue indexing");
                                result = entry;
                            }
                            entry = zins.getNextJarEntry();
                            ++i;
                        }
                        log.debug("findEntry: Indexing complete, returning {}", result);
                        JarEntry jarEntry = result;
                        return jarEntry;
                    }
                    finally {
                        this.entryMap = tmpEntryMap;
                    }
                }
            }
        }
        if ((entryNumO = (Number)this.entryMap.get(path)) == null) {
            log.debug("findEntry: This archive does not contain {}", (Object)path);
            return null;
        }
        log.debug("findEntry: {} is entry #{}", (Object)path, (Object)entryNumO);
        JarEntry entry = zins.getNextJarEntry();
        for (int entryNum = entryNumO.intValue(); entryNum > 0 && entry != null; --entryNum) {
            entry = zins.getNextJarEntry();
        }
        return entry;
    }

    private static class ArchiveClassPathResource
    extends ClassLoaderResource {
        private final JarEntry jarEntry;

        private ArchiveClassPathResource(ArchiveClassPathEntry pathEntry, JarEntry jarEntry) {
            super(pathEntry, jarEntry.getName(), pathEntry.getProperty());
            this.jarEntry = jarEntry;
        }

        public URL getURL() {
            return this.getArchiveClassPathEntry().getURL(this.getName());
        }

        public URL getCodeSourceURL() {
            return this.getArchiveClassPathEntry().getCodeSourceURL();
        }

        public InputStream getInputStream() throws RepositoryException {
            InputStream inputStream;
            JarInputStream zipIns = null;
            JarEntry entry = null;
            try {
                zipIns = ArchiveClassPathEntry.getJarInputStream(this.getProperty());
                entry = this.getArchiveClassPathEntry().findEntry(zipIns, this.getName());
                if (entry != null) {
                    JarInputStream jarInputStream = zipIns;
                    return jarInputStream;
                }
                log.warn("Cannot find entry {} in the archive {} anymore!", (Object)this.getName(), (Object)this.getClassPathEntry().getPath());
                inputStream = null;
            }
            catch (IOException ioe) {
                throw new RepositoryException((Throwable)ioe);
            }
            finally {
                if (entry == null && zipIns != null) {
                    try {
                        zipIns.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return inputStream;
        }

        public int getContentLength() {
            return (int)this.jarEntry.getSize();
        }

        public String getPath() {
            try {
                return this.getProperty().getPath();
            }
            catch (RepositoryException re) {
                String archivePath = this.getClassPathEntry().getPath();
                log.warn("Cannot access the path of the archive property below " + archivePath, (Throwable)re);
                return archivePath;
            }
        }

        public long getLastModificationTime() {
            return this.jarEntry.getTime();
        }

        public Manifest getManifest() {
            return this.getArchiveClassPathEntry().getManifest();
        }

        protected ArchiveClassPathEntry getArchiveClassPathEntry() {
            return (ArchiveClassPathEntry)this.getClassPathEntry();
        }
    }
}

