/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.classloader.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectoryClassPathEntry
extends ClassPathEntry {
    private static final Logger log = LoggerFactory.getLogger((Class)DirectoryClassPathEntry.class);

    DirectoryClassPathEntry(Session ticket, String handle) {
        super(ticket, handle);
    }

    public ClassLoaderResource getResource(String name) {
        try {
            Property prop = Util.getProperty(this.session.getItem(this.path + name));
            if (prop != null) {
                return new ClassLoaderResource(this, name, prop);
            }
            log.debug("getResource: resource {} not found below {} ", (Object)name, (Object)this.path);
        }
        catch (PathNotFoundException pnfe) {
            log.debug("getResource: Classpath entry {} does not have resource {}", (Object)this.path, (Object)name);
        }
        catch (RepositoryException cbe) {
            log.warn("getResource: problem accessing the resource {} below {}", (Object)new Object[]{name, this.path}, (Object)cbe);
        }
        return null;
    }

    ClassPathEntry copy() {
        return this;
    }
}

