/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.classloader.PatternPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicPatternPath
extends PatternPath
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)DynamicPatternPath.class);
    private final ArrayList listeners = new ArrayList();
    private boolean isRegistered;

    DynamicPatternPath(Session session, String[] pathPatterns) {
        super(session, pathPatterns);
    }

    synchronized void addListener(Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (!this.isRegistered) {
            log.debug("addListener: Register with observation service");
            this.registerEventListener();
        }
        if (!this.listeners.contains(listener)) {
            log.debug("addListener: Listener {}", (Object)listener);
            this.listeners.add(listener);
        } else {
            log.info("addListener: Listener {} already added", (Object)listener);
        }
    }

    synchronized void removeListener(Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.listeners.remove(listener)) {
            log.debug("removeListener: Listener {}", (Object)listener);
        } else {
            log.info("removeListener: Listener {} not registered", (Object)listener);
        }
        if (this.listeners.size() == 0) {
            log.debug("removeListener: Deregister from observation service");
            this.unregisterEventListener();
        }
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event event = events.nextEvent();
            if (event.getType() == 16) continue;
            try {
                String path = event.getPath();
                if (!this.matchPath(path)) continue;
                log.debug("onEvent: Listener Notification due to {}", (Object)path);
                this.notifyListeners();
                return;
            }
            catch (RepositoryException re) {
                log.info("onEvent: Cannot check events", (Throwable)re);
            }
        }
    }

    private void registerEventListener() {
        if (this.isRegistered) {
            log.debug("registerModificationListener: Already registered");
            return;
        }
        try {
            ObservationManager om = this.getSession().getWorkspace().getObservationManager();
            om.addEventListener((EventListener)this, 65535, "/", true, null, null, false);
            this.isRegistered = true;
        }
        catch (RepositoryException re) {
            log.warn("registerModificationListener", (Throwable)re);
        }
    }

    private void unregisterEventListener() {
        if (!this.isRegistered) {
            log.debug("deregisterModificationListener: Not registered");
            return;
        }
        try {
            ObservationManager om = this.getSession().getWorkspace().getObservationManager();
            om.removeEventListener((EventListener)this);
            this.isRegistered = false;
        }
        catch (RepositoryException re) {
            log.warn("deregisterModificationListener", (Throwable)re);
        }
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            log.debug("notifyListeners: Notifying listener {}", (Object)listener);
            try {
                listener.pathChanged();
                continue;
            }
            catch (Exception e) {
                log.warn("notifyListeners: Listener {} failed", (Object)listener, (Object)e);
            }
        }
    }

    static interface Listener {
        public void pathChanged();
    }
}

