/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.classloader.DynamicPatternPath;
import org.apache.jackrabbit.classloader.RepositoryClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRepositoryClassLoader
extends RepositoryClassLoader
implements EventListener,
DynamicPatternPath.Listener {
    private static final Logger log = LoggerFactory.getLogger((Class)DynamicRepositoryClassLoader.class);
    private Map modTimeCache = new HashMap();
    private boolean dirty = false;
    private ClassPathEntry[] addedRepositories;

    public DynamicRepositoryClassLoader(Session session, String[] classPath, ClassLoader parent) {
        super(session, new DynamicPatternPath(session, classPath), parent);
        this.registerModificationListener();
        log.debug("DynamicRepositoryClassLoader: {} ready", (Object)this);
    }

    private DynamicRepositoryClassLoader(Session session, DynamicRepositoryClassLoader old, ClassLoader parent) {
        super(session, old.getHandles(), parent);
        this.setRepository(DynamicRepositoryClassLoader.resetClassPathEntries(old.getRepository()));
        this.setAddedRepositories(DynamicRepositoryClassLoader.resetClassPathEntries(old.getAddedRepositories()));
        this.buildRepository();
        this.registerModificationListener();
        old.destroy();
        log.debug("DynamicRepositoryClassLoader: Copied {}. Do not use that anymore", (Object)old);
    }

    public void destroy() {
        if (this.isDestroyed()) {
            log.debug("Instance is already destroyed");
            return;
        }
        this.unregisterListener();
        this.addedRepositories = null;
        super.destroy();
    }

    public synchronized boolean shouldReload(String name) {
        return this.shouldReload(name, false);
    }

    public synchronized boolean shouldReload(String name, boolean force) {
        if (this.isDestroyed()) {
            log.warn("Classloader already destroyed, reload required");
            return true;
        }
        ClassLoaderResource res = this.getCachedResource(name);
        if (res != null) {
            log.debug("shouldReload: Expiring cache entry {}", (Object)res);
            if (force) {
                log.debug("shouldReload: Forced dirty flag");
                this.dirty = true;
                return true;
            }
            return this.expireResource(res);
        }
        return false;
    }

    public synchronized boolean shouldReload() {
        if (this.isDirty()) {
            log.debug("shouldReload: Dirty, need reload");
            return true;
        }
        Iterator iter = this.getCachedResources();
        while (iter.hasNext()) {
            if (!this.expireResource((ClassLoaderResource)iter.next())) continue;
            log.debug("shouldReload: Found expired resource, need reload");
            return true;
        }
        log.debug("shouldReload: No expired resource found, no need to reload");
        return false;
    }

    public boolean isDirty() {
        return this.isDestroyed() || this.dirty || !this.getSession().isLive();
    }

    public DynamicRepositoryClassLoader reinstantiate(Session session, ClassLoader parent) {
        log.debug("reinstantiate: Copying {} with parent {}", (Object)this, (Object)parent);
        if (this.isDestroyed()) {
            throw new IllegalStateException("Destroyed class loader cannot be recreated");
        }
        DynamicRepositoryClassLoader newLoader = new DynamicRepositoryClassLoader(session, this, parent);
        return newLoader;
    }

    public void reconfigure(String[] classPath) {
        if (log.isDebugEnabled()) {
            log.debug("reconfigure: Reconfiguring the with {}", Arrays.asList(classPath));
        }
        if (this.isDestroyed()) {
            log.warn("Cannot reconfigure this destroyed class loader");
            return;
        }
        ((DynamicPatternPath)this.getHandles()).removeListener(this);
        this.setHandles(new DynamicPatternPath(this.getSession(), classPath));
        this.buildRepository();
        ((DynamicPatternPath)this.getHandles()).addListener(this);
        this.dirty = !this.hasLoadedResources();
        log.debug("reconfigure: Class loader is dirty now: {}", (Object)(this.isDirty() ? "yes" : "no"));
    }

    ClassLoaderResource findClassLoaderResource(String name) {
        Property prop;
        ClassLoaderResource res = super.findClassLoaderResource(name);
        if (res != null && (prop = res.getExpiryProperty()) != null) {
            try {
                this.modTimeCache.put(prop.getPath(), res);
            }
            catch (RepositoryException re) {
                log.warn("Cannot register the resource " + res + " for expiry", (Throwable)re);
            }
        }
        return res;
    }

    protected synchronized void buildRepository() {
        super.buildRepository();
        ClassPathEntry[] addedPath = this.getAddedRepositories();
        if (addedPath != null && addedPath.length > 0) {
            ClassPathEntry[] oldClassPath = this.getRepository();
            ClassPathEntry[] newClassPath = new ClassPathEntry[oldClassPath.length + addedPath.length];
            System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
            System.arraycopy(addedPath, 0, newClassPath, oldClassPath.length, addedPath.length);
            this.setRepository(newClassPath);
        }
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            String path;
            Event event = events.nextEvent();
            try {
                path = event.getPath();
            }
            catch (RepositoryException re) {
                log.warn("onEvent: Cannot get path of event, ignoring", (Throwable)re);
                continue;
            }
            log.debug("onEvent: Item {} has been modified, checking with cache", (Object)path);
            ClassLoaderResource resource = (ClassLoaderResource)this.modTimeCache.get(path);
            if (resource != null) {
                log.debug("pageModified: Expiring cache entry {}", (Object)resource);
                this.expireResource(resource);
                continue;
            }
            if (event.getType() != 1 && event.getType() != 4) continue;
            log.debug("pageModified: Clearing not-found cache for possible new class");
            this.cleanCache();
        }
    }

    public void pathChanged() {
        log.debug("handleListChanged: The path list has changed");
        this.buildRepository();
        this.dirty = true;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(", dirty: ");
        buf.append(this.isDirty());
        return buf.toString();
    }

    protected void setAddedRepositories(ClassPathEntry[] addedRepositories) {
        this.addedRepositories = addedRepositories;
    }

    protected ClassPathEntry[] getAddedRepositories() {
        return this.addedRepositories;
    }

    protected void addClassPathEntry(ClassPathEntry cpe) {
        super.addClassPathEntry(cpe);
        ClassPathEntry[] oldClassPath = this.getAddedRepositories();
        ClassPathEntry[] newClassPath = this.addClassPathEntry(oldClassPath, cpe);
        this.setAddedRepositories(newClassPath);
    }

    private final void registerModificationListener() {
        ((DynamicPatternPath)this.getHandles()).addListener(this);
        log.debug("registerModificationListener: Registering to the observation service");
        try {
            ObservationManager om = this.getSession().getWorkspace().getObservationManager();
            om.addEventListener((EventListener)this, 255, "/", true, null, null, false);
        }
        catch (RepositoryException re) {
            log.error("registerModificationListener: Cannot register " + this + " with observation manager", (Throwable)re);
        }
    }

    private final void unregisterListener() {
        ((DynamicPatternPath)this.getHandles()).removeListener(this);
        log.debug("registerModificationListener: Deregistering from the observation service");
        try {
            ObservationManager om = this.getSession().getWorkspace().getObservationManager();
            om.removeEventListener((EventListener)this);
        }
        catch (RepositoryException re) {
            log.error("unregisterListener: Cannot unregister " + this + " from observation manager", (Throwable)re);
        }
    }

    private boolean expireResource(ClassLoaderResource resource) {
        boolean exp = resource.getLoadedClass() != null && resource.isExpired();
        this.dirty |= exp;
        log.debug("expireResource: Loader dirty: {}", (Object)new Boolean(this.isDirty()));
        return exp;
    }

    private static ClassPathEntry[] resetClassPathEntries(ClassPathEntry[] oldClassPath) {
        if (oldClassPath != null) {
            for (int i = 0; i < oldClassPath.length; ++i) {
                ClassPathEntry entry = oldClassPath[i];
                log.debug("resetClassPathEntries: Cloning {}", (Object)entry);
                oldClassPath[i] = entry.copy();
            }
        } else {
            log.debug("resetClassPathEntries: No list to reset");
        }
        return oldClassPath;
    }
}

