/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.classloader.ArchiveClassPathEntry;
import org.apache.jackrabbit.classloader.ClassLoaderResource;
import org.apache.jackrabbit.classloader.ClassPathEntry;
import org.apache.jackrabbit.classloader.NodeTypeSupport;
import org.apache.jackrabbit.classloader.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExpandingArchiveClassPathEntry
extends ArchiveClassPathEntry {
    public static final String TYPE_JARFILE = "rep:jarFile";
    public static final String NODE_JARCONTENTS = "rep:jarContents";
    public static final String PROP_EXPAND_DATE = "rep:jarExpanded";
    private static final Logger log = LoggerFactory.getLogger((Class)ExpandingArchiveClassPathEntry.class);
    private Node jarContents;

    ExpandingArchiveClassPathEntry(Property prop, String path) throws RepositoryException {
        super(prop, path);
    }

    private ExpandingArchiveClassPathEntry(ExpandingArchiveClassPathEntry base) {
        super(base);
    }

    public ClassLoaderResource getResource(String name) {
        try {
            Property resProp;
            Node jarContents = this.getJarContents();
            Node resItem = null;
            if (jarContents.hasNode(name)) {
                resItem = jarContents.getNode(name);
            } else if (jarContents.hasProperty(name)) {
                resItem = jarContents.getProperty(name);
            }
            Property property = resProp = resItem != null ? Util.getProperty((Item)resItem) : null;
            if (resProp != null) {
                return new ClassLoaderResource(this, name, resProp){

                    public URL getURL() {
                        return ExpandingArchiveClassPathEntry.this.getURL(this.getName());
                    }

                    public URL getCodeSourceURL() {
                        return ExpandingArchiveClassPathEntry.this.getCodeSourceURL();
                    }

                    public Manifest getManifest() {
                        return ExpandingArchiveClassPathEntry.this.getManifest();
                    }

                    protected Property getExpiryProperty() {
                        return ExpandingArchiveClassPathEntry.this.getProperty();
                    }
                };
            }
            log.debug("getResource: resource {} not found in archive {}", (Object)name, (Object)this.path);
        }
        catch (RepositoryException re) {
            log.warn("getResource: problem accessing the archive {} for {}", (Object)new Object[]{this.path, name}, (Object)re.toString());
        }
        return null;
    }

    ClassPathEntry copy() {
        return new ExpandingArchiveClassPathEntry(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getJarContents() throws RepositoryException {
        if (this.jarContents == null) {
            Node jarNode = null;
            Node jarRoot = null;
            try {
                Item jarItem = this.session.getItem(this.getPath());
                Node node = jarNode = jarItem.isNode() ? (Node)jarItem : jarItem.getParent();
                if (jarNode.isNodeType(TYPE_JARFILE)) {
                    long lastMod = Util.getLastModificationTime(this.getProperty());
                    long expanded = jarNode.getProperty(PROP_EXPAND_DATE).getLong();
                    jarRoot = jarNode.getNode(NODE_JARCONTENTS);
                    if (lastMod <= expanded) {
                        jarRoot.remove();
                        jarRoot = null;
                    }
                } else {
                    if (!jarNode.canAddMixin(TYPE_JARFILE)) {
                        throw new RepositoryException("Cannot unpack JAR file contents into " + jarNode.getPath());
                    }
                    jarNode.addMixin(TYPE_JARFILE);
                    jarNode.setProperty(PROP_EXPAND_DATE, Calendar.getInstance());
                }
                if (jarRoot == null) {
                    jarRoot = jarNode.addNode(NODE_JARCONTENTS, "nt:folder");
                    this.unpack(jarRoot);
                    jarNode.save();
                }
            }
            finally {
                if (jarNode != null && jarNode.isModified()) {
                    log.warn("Rolling back unsaved changes on JAR node {}", (Object)this.getPath());
                    try {
                        jarNode.refresh(false);
                    }
                    catch (RepositoryException re) {
                        log.warn("Cannot rollback changes after failure to expand " + this.getPath(), (Throwable)re);
                    }
                }
            }
            this.jarContents = jarRoot;
        }
        return this.jarContents;
    }

    private void unpack(Node jarRoot) throws RepositoryException {
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(this.getProperty().getStream());
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    this.unpackFolder(jarRoot, entry.getName());
                } else {
                    this.unpackFile(jarRoot, entry, zin);
                }
                entry = zin.getNextEntry();
            }
        }
        catch (IOException ioe) {
            throw new RepositoryException("Problem reading JAR contents of " + this.getPath(), (Throwable)ioe);
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private Node unpackFolder(Node root, String path) throws RepositoryException {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (root.hasNode(path)) {
            return root.getNode(path);
        }
        StringTokenizer tokener = new StringTokenizer(path, "/");
        while (tokener.hasMoreTokens()) {
            String label = tokener.nextToken();
            if (root.hasNode(label)) {
                root = root.getNode(label);
                continue;
            }
            root = root.addNode(label, "nt:folder");
        }
        return root;
    }

    private void unpackFile(Node root, ZipEntry entry, InputStream ins) throws RepositoryException {
        Node parent;
        int slash = entry.getName().lastIndexOf(47);
        String label = entry.getName().substring(slash + 1);
        Node node = parent = slash <= 0 ? root : this.unpackFolder(root, entry.getName().substring(0, slash));
        if (parent.hasNode(label)) {
            parent.getNode(label).remove();
        }
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(entry.getTime());
        String mimeType = URLConnection.guessContentTypeFromName(label);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        Node ntFile = parent.addNode(label, "nt:file");
        Node content = ntFile.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:data", ins);
        content.setProperty("jcr:lastModified", lastModified);
    }

    static synchronized boolean canExpandArchives(Session session) {
        try {
            session.getWorkspace().getNodeTypeManager().getNodeType(TYPE_JARFILE);
            log.debug("Required node type exists, can expand archives");
            return true;
        }
        catch (NoSuchNodeTypeException nst) {
            log.debug("Required node types does not exist, try to define");
        }
        catch (RepositoryException re) {
            log.info("Cannot check for required node type, cannot expand archives", (Throwable)re);
            return false;
        }
        try {
            Workspace workspace = session.getWorkspace();
            return NodeTypeSupport.registerNodeType(workspace);
        }
        catch (Throwable t) {
            log.info("Error registering node type", t);
            return false;
        }
    }
}

