/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.classloader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatternPath {
    private static final Logger log = LoggerFactory.getLogger((Class)PatternPath.class);
    private final Session session;
    private final String[] patterns;

    PatternPath(Session session, String[] pathPatterns) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        ArrayList patternList = new ArrayList();
        for (int i = 0; i < pathPatterns.length; ++i) {
            this.addChecked(patternList, pathPatterns[i]);
        }
        this.patterns = patternList.toArray(new String[patternList.size()]);
        this.session = session;
    }

    Session getSession() {
        return this.session;
    }

    String[] getPath() {
        return (String[])this.patterns.clone();
    }

    List getExpandedPaths() throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>(this.patterns.length);
        Node root = this.session.getRootNode();
        for (int i = 0; i < this.patterns.length; ++i) {
            String entry = this.patterns[i];
            if (entry.indexOf(42) >= 0 || entry.indexOf(124) >= 0) {
                PatternPath.scan(root, entry, result);
                continue;
            }
            result.add(entry);
        }
        return result;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("PatternPath: [");
        for (int i = 0; i < this.patterns.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.patterns[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    private void addChecked(List patternList, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            log.debug("addChecked: Not adding null/empty pattern");
        } else {
            while (pattern.endsWith("/") && pattern.length() > 1) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            log.debug("addChecked: Adding {}");
            patternList.add(pattern);
        }
    }

    private static void scan(Node root, String pathPattern, List gather) throws RepositoryException {
        ArrayList<Node> candidates = new ArrayList<Node>();
        candidates.add(root);
        StringTokenizer patterns = new StringTokenizer(pathPattern, "/");
        boolean moreTokens = patterns.hasMoreTokens();
        while (moreTokens) {
            String pattern = patterns.nextToken();
            moreTokens = patterns.hasMoreTokens();
            ArrayList<Object> newCandidates = new ArrayList<Object>();
            Iterator ci = candidates.iterator();
            while (ci.hasNext()) {
                Node current = (Node)ci.next();
                NodeIterator ni = current.getNodes(pattern);
                while (ni.hasNext()) {
                    newCandidates.add(ni.nextNode());
                }
                if (moreTokens) continue;
                PropertyIterator pi = current.getProperties(pattern);
                while (pi.hasNext()) {
                    newCandidates.add(pi.nextProperty());
                }
            }
            candidates.clear();
            candidates = newCandidates;
        }
        Iterator ci = candidates.iterator();
        while (ci.hasNext()) {
            Item current = (Item)ci.next();
            gather.add(current.getPath());
        }
    }

    boolean matchPath(String path) {
        StringTokenizer exploded = new StringTokenizer(path, "/");
        block0: for (int i = 0; i < this.patterns.length; ++i) {
            StringTokenizer exEntry = new StringTokenizer(this.patterns[i], "/");
            if (exploded.countTokens() != exEntry.countTokens()) continue;
            while (exploded.hasMoreTokens()) {
                if (ChildrenCollectorFilter.matches((String)exploded.nextToken(), (String)exEntry.nextToken())) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }
}

