/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RangeIteratorDecorator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;
import org.apache.jackrabbit.spi2jcr.QueryResultRowImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryInfoImpl
implements QueryInfo {
    private static final Logger log = LoggerFactory.getLogger(QueryInfoImpl.class);
    private final QueryResult result;
    private final IdFactoryImpl idFactory;
    private final NamePathResolver resolver;
    private final QValueFactory qValueFactory;
    private final String[] columnNames;
    private final Name[] selectorNames;

    public QueryInfoImpl(QueryResult result, IdFactoryImpl idFactory, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this.result = result;
        this.idFactory = idFactory;
        this.resolver = resolver;
        this.qValueFactory = qValueFactory;
        this.columnNames = result.getColumnNames();
        this.selectorNames = QueryInfoImpl.getSelectorNames(result, resolver);
    }

    public RangeIterator getRows() {
        try {
            return new RangeIteratorDecorator((RangeIterator)this.result.getRows()){

                public Object next() {
                    try {
                        return new QueryResultRowImpl((Row)super.next(), QueryInfoImpl.this.columnNames, QueryInfoImpl.this.selectorNames, QueryInfoImpl.this.idFactory, QueryInfoImpl.this.resolver, QueryInfoImpl.this.qValueFactory);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception when creating QueryResultRowImpl: " + e.getMessage(), (Throwable)e);
                        throw new NoSuchElementException();
                    }
                }
            };
        }
        catch (RepositoryException e) {
            return RangeIteratorAdapter.EMPTY;
        }
    }

    public String[] getColumnNames() {
        String[] names = new String[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, names, 0, this.columnNames.length);
        return names;
    }

    public Name[] getSelectorNames() {
        Name[] names = new Name[this.selectorNames.length];
        System.arraycopy(this.selectorNames, 0, names, 0, this.selectorNames.length);
        return names;
    }

    private static Name[] getSelectorNames(QueryResult result, NamePathResolver resolver) throws RepositoryException {
        List<String> sn = Arrays.asList(result.getSelectorNames());
        Name[] selectorNames = new Name[sn.size()];
        for (int i = 0; i < sn.size(); ++i) {
            selectorNames[i] = resolver.getQName(sn.get(i));
        }
        return selectorNames;
    }
}

