/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.util.TraversingItemVisitor;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.ItemInfoCacheImpl;
import org.apache.jackrabbit.spi.commons.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.QPropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2jcr.BatchReadConfig;
import org.apache.jackrabbit.spi2jcr.ChildInfoImpl;
import org.apache.jackrabbit.spi2jcr.EventFactory;
import org.apache.jackrabbit.spi2jcr.EventSubscription;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;
import org.apache.jackrabbit.spi2jcr.LockInfoImpl;
import org.apache.jackrabbit.spi2jcr.NodeInfoImpl;
import org.apache.jackrabbit.spi2jcr.PropertyInfoImpl;
import org.apache.jackrabbit.spi2jcr.QueryInfoImpl;
import org.apache.jackrabbit.spi2jcr.SessionInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
implements RepositoryService {
    private final Repository repository;
    private final BatchReadConfig batchReadConfig;
    private final IdFactoryImpl idFactory = (IdFactoryImpl)IdFactoryImpl.getInstance();
    private QValueFactory qValueFactory = QValueFactoryImpl.getInstance();
    private final boolean supportsObservation;
    private final int itemInfoCacheSize;

    public RepositoryServiceImpl(Repository repository, BatchReadConfig batchReadConfig) {
        this(repository, batchReadConfig, 5000);
    }

    public RepositoryServiceImpl(Repository repository, BatchReadConfig batchReadConfig, int itemInfoCacheSize) {
        this.repository = repository;
        this.batchReadConfig = batchReadConfig;
        this.supportsObservation = "true".equals(repository.getDescriptor("option.observation.supported"));
        this.itemInfoCacheSize = itemInfoCacheSize;
        try {
            Session s = repository.login((Credentials)new GuestCredentials());
            ValueFactory vf = s.getValueFactory();
            if (vf instanceof ValueFactoryQImpl) {
                this.qValueFactory = ((ValueFactoryQImpl)vf).getQValueFactory();
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public NameFactory getNameFactory() {
        return NameFactoryImpl.getInstance();
    }

    public PathFactory getPathFactory() {
        return PathFactoryImpl.getInstance();
    }

    public QValueFactory getQValueFactory() {
        return this.qValueFactory;
    }

    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return new ItemInfoCacheImpl(this.itemInfoCacheSize);
    }

    public Map<String, QValue[]> getRepositoryDescriptors() throws RepositoryException {
        HashMap<String, QValue[]> descriptors = new HashMap<String, QValue[]>();
        for (String key : this.repository.getDescriptorKeys()) {
            if (key.equals("option.transactions.supported")) {
                descriptors.put(key, new QValue[]{this.qValueFactory.create(false)});
                continue;
            }
            Value[] vs = this.repository.getDescriptorValues(key);
            QValue[] qvs = new QValue[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                DefaultNamePathResolver resolver = new DefaultNamePathResolver(new NamespaceResolver(){

                    public String getURI(String prefix) {
                        return prefix;
                    }

                    public String getPrefix(String uri) {
                        return uri;
                    }
                });
                qvs[i] = ValueFormat.getQValue((Value)vs[i], (NamePathResolver)resolver, (QValueFactory)this.qValueFactory);
            }
            descriptors.put(key, qvs);
        }
        return descriptors;
    }

    public SessionInfo obtain(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Credentials duplicate = SessionInfoImpl.duplicateCredentials(credentials);
        return new SessionInfoImpl(this.repository.login(credentials, workspaceName), duplicate, this.getNameFactory(), this.getPathFactory());
    }

    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Session s = this.repository.login(sInfo.getCredentials(), workspaceName);
        return new SessionInfoImpl(s, sInfo.getCredentials(), this.getNameFactory(), this.getPathFactory());
    }

    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws LoginException, RepositoryException {
        Credentials duplicate = SessionInfoImpl.duplicateCredentials(credentials);
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return new SessionInfoImpl(sInfo.getSession().impersonate(credentials), duplicate, this.getNameFactory(), this.getPathFactory());
    }

    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        for (EventSubscription s : sInfo.getSubscriptions()) {
            s.dispose();
        }
        sInfo.getSession().logout();
    }

    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        Session s = this.getSessionInfoImpl(sessionInfo).getSession();
        return s.getWorkspace().getAccessibleWorkspaceNames();
    }

    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        String path = this.pathForId(itemId, sInfo);
        try {
            String actStr;
            if (actions.length == 1) {
                actStr = actions[0];
            } else {
                String comma = "";
                actStr = "";
                for (String action : actions) {
                    actStr = actStr + comma;
                    actStr = actStr + action;
                    comma = ",";
                }
            }
            sInfo.getSession().checkPermission(path, actStr);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new QNodeDefinitionImpl(this.getNode(nodeId, sInfo).getDefinition(), sInfo.getNamePathResolver());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new QPropertyDefinitionImpl(this.getProperty(propertyId, sInfo).getDefinition(), sInfo.getNamePathResolver(), this.getQValueFactory());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node node = this.getNode(nodeId, sInfo);
        try {
            return new NodeInfoImpl(node, this.idFactory, sInfo.getNamePathResolver());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node node = this.getNode(nodeId, sInfo);
        Name ntName = null;
        try {
            ntName = sInfo.getNamePathResolver().getQName(node.getProperty("jcr:primaryType").getString());
        }
        catch (NameException e) {
            // empty catch block
        }
        int depth = this.batchReadConfig.getDepth(ntName);
        if (depth == 0) {
            NodeInfoImpl info;
            try {
                info = new NodeInfoImpl(node, this.idFactory, sInfo.getNamePathResolver());
            }
            catch (NameException e) {
                throw new RepositoryException((Throwable)e);
            }
            return Collections.singletonList(info).iterator();
        }
        final ArrayList itemInfos = new ArrayList();
        TraversingItemVisitor visitor = new TraversingItemVisitor(false, depth){

            protected void entering(Property property, int i) throws RepositoryException {
                try {
                    itemInfos.add(new PropertyInfoImpl(property, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver(), RepositoryServiceImpl.this.getQValueFactory()));
                }
                catch (NameException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }

            protected void entering(Node node, int i) throws RepositoryException {
                try {
                    itemInfos.add(new NodeInfoImpl(node, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver()));
                }
                catch (NameException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }

            protected void leaving(Property property, int i) {
            }

            protected void leaving(Node node, int i) {
            }
        };
        visitor.visit(node);
        return itemInfos.iterator();
    }

    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeIterator children = this.getNode(parentId, sInfo).getNodes();
        ArrayList<ChildInfoImpl> childInfos = new ArrayList<ChildInfoImpl>();
        try {
            while (children.hasNext()) {
                childInfos.add(new ChildInfoImpl(children.nextNode(), sInfo.getNamePathResolver()));
            }
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        return childInfos.iterator();
    }

    public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node node = this.getNode(nodeId, sInfo);
        String jcrName = propertyName == null ? null : sInfo.getNamePathResolver().getJCRName(propertyName);
        ArrayList<PropertyId> ids = new ArrayList<PropertyId>();
        PropertyIterator it = weakReferences ? node.getWeakReferences(jcrName) : node.getReferences(jcrName);
        while (it.hasNext()) {
            ids.add(this.idFactory.createPropertyId(it.nextProperty(), sInfo.getNamePathResolver()));
        }
        return ids.iterator();
    }

    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new PropertyInfoImpl(this.getProperty(propertyId, sInfo), this.idFactory, sInfo.getNamePathResolver(), this.getQValueFactory());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        return new BatchImpl(this.getSessionInfoImpl(sessionInfo));
    }

    public void submit(Batch batch) throws PathNotFoundException, ItemNotFoundException, NoSuchNodeTypeException, ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation: " + batch.getClass().getName());
        }
        ((BatchImpl)batch).end();
    }

    public void importXml(SessionInfo sessionInfo, final NodeId parentId, final InputStream xmlStream, final int uuidBehaviour) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String path = RepositoryServiceImpl.this.pathForId((ItemId)parentId, sInfo);
                try {
                    sInfo.getSession().getWorkspace().importXML(path, xmlStream, uuidBehaviour);
                }
                catch (IOException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }, sInfo);
    }

    public void move(SessionInfo sessionInfo, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, sInfo);
                StringBuffer destPath = new StringBuffer(RepositoryServiceImpl.this.pathForId((ItemId)destParentNodeId, sInfo));
                if (destPath.length() > 1) {
                    destPath.append("/");
                }
                destPath.append(sInfo.getNamePathResolver().getJCRName(destName));
                sInfo.getSession().getWorkspace().move(srcPath, destPath.toString());
                return null;
            }
        }, sInfo);
    }

    public void copy(SessionInfo sessionInfo, final String srcWorkspaceName, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws RepositoryException {
                Workspace ws = sInfo.getSession().getWorkspace();
                String destPath = RepositoryServiceImpl.this.getDestinationPath(destParentNodeId, destName, sInfo);
                if (ws.getName().equals(srcWorkspaceName)) {
                    String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, sInfo);
                    ws.copy(srcPath, destPath);
                } else {
                    SessionInfoImpl srcInfo = RepositoryServiceImpl.this.getSessionInfoImpl(RepositoryServiceImpl.this.obtain(sInfo, srcWorkspaceName));
                    try {
                        String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, srcInfo);
                        ws.copy(srcWorkspaceName, srcPath, destPath);
                    }
                    finally {
                        RepositoryServiceImpl.this.dispose(srcInfo);
                    }
                }
                return null;
            }
        }, sInfo);
    }

    public void update(SessionInfo sessionInfo, final NodeId nodeId, final String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, sInfo).update(srcWorkspaceName);
                return null;
            }
        }, sInfo);
    }

    public void clone(final SessionInfo sessionInfo, final String srcWorkspaceName, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName, final boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws RepositoryException {
                SessionInfoImpl srcInfo = RepositoryServiceImpl.this.getSessionInfoImpl(RepositoryServiceImpl.this.obtain(sessionInfo, srcWorkspaceName));
                try {
                    String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, srcInfo);
                    String destPath = RepositoryServiceImpl.this.getDestinationPath(destParentNodeId, destName, sInfo);
                    Workspace wsp = sInfo.getSession().getWorkspace();
                    wsp.clone(srcWorkspaceName, srcPath, destPath, removeExisting);
                }
                finally {
                    RepositoryServiceImpl.this.dispose(srcInfo);
                }
                return null;
            }
        }, sInfo);
    }

    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            Lock lock = this.getNode(nodeId, sInfo).getLock();
            return LockInfoImpl.createLockInfo(lock, this.idFactory);
        }
        catch (LockException e) {
            return null;
        }
    }

    public LockInfo lock(SessionInfo sessionInfo, final NodeId nodeId, final boolean deep, final boolean sessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (LockInfo)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                Lock lock = n.lock(deep, sessionScoped);
                return LockInfoImpl.createLockInfo(lock, RepositoryServiceImpl.this.idFactory);
            }
        }, sInfo);
    }

    public LockInfo lock(SessionInfo sessionInfo, final NodeId nodeId, final boolean deep, final boolean sessionScoped, final long timeoutHint, final String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (LockInfo)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                LockManager lMgr = sInfo.getSession().getWorkspace().getLockManager();
                Lock lock = lMgr.lock(n.getPath(), deep, sessionScoped, timeoutHint, ownerHint);
                return LockInfoImpl.createLockInfo(lock, RepositoryServiceImpl.this.idFactory);
            }
        }, sInfo);
    }

    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws LockException, RepositoryException {
        this.getNode(nodeId, this.getSessionInfoImpl(sessionInfo)).getLock().refresh();
    }

    public void unlock(SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, sInfo).unlock();
                return null;
            }
        }, sInfo);
    }

    public NodeId checkin(final SessionInfo sessionInfo, final NodeId nodeId) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Version newVersion = (Version)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                return RepositoryServiceImpl.this.getNode(nodeId, RepositoryServiceImpl.this.getSessionInfoImpl(sessionInfo)).checkin();
            }
        }, sInfo);
        return this.idFactory.createNodeId((Node)newVersion);
    }

    public void checkout(SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, sInfo).checkout();
                return null;
            }
        }, sInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(SessionInfo sessionInfo, final NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node activity = activityId == null ? null : this.getNode(activityId, sInfo);
        VersionManager vMgr = sInfo.getSession().getWorkspace().getVersionManager();
        vMgr.setActivity(activity);
        try {
            this.executeWithLocalEvents(new Callable(){

                public Object run() throws RepositoryException {
                    RepositoryServiceImpl.this.getNode(nodeId, sInfo).checkout();
                    return null;
                }
            }, sInfo);
        }
        finally {
            vMgr.setActivity(null);
        }
    }

    public NodeId checkpoint(SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Version newVersion = (Version)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                VersionManager vMgr = sInfo.getSession().getWorkspace().getVersionManager();
                return vMgr.checkpoint(RepositoryServiceImpl.this.getNodePath(nodeId, sInfo));
            }
        }, sInfo);
        return this.idFactory.createNodeId((Node)newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeId checkpoint(SessionInfo sessionInfo, final NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node activity = activityId == null ? null : this.getNode(activityId, sInfo);
        VersionManager vMgr = sInfo.getSession().getWorkspace().getVersionManager();
        vMgr.setActivity(activity);
        try {
            Version newVersion = (Version)this.executeWithLocalEvents(new Callable(){

                public Object run() throws RepositoryException {
                    VersionManager vMgr = sInfo.getSession().getWorkspace().getVersionManager();
                    return vMgr.checkpoint(RepositoryServiceImpl.this.getNodePath(nodeId, sInfo));
                }
            }, sInfo);
            NodeId nodeId2 = this.idFactory.createNodeId((Node)newVersion);
            return nodeId2;
        }
        finally {
            vMgr.setActivity(null);
        }
    }

    public void removeVersion(SessionInfo sessionInfo, final NodeId versionHistoryId, final NodeId versionId) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                Node version = RepositoryServiceImpl.this.getNode(versionId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistor node");
                }
                ((VersionHistory)vHistory).removeVersion(version.getName());
                return null;
            }
        }, sInfo);
    }

    public void restore(final SessionInfo sessionInfo, final NodeId nodeId, final NodeId versionId, final boolean removeExisting) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Version v = (Version)RepositoryServiceImpl.this.getNode(versionId, sInfo);
                if (RepositoryServiceImpl.this.hasNode(sessionInfo, nodeId)) {
                    Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                    n.restore(v, removeExisting);
                } else {
                    Node n = null;
                    Path relPath = null;
                    Path path = nodeId.getPath();
                    if (nodeId.getUniqueID() != null) {
                        n = RepositoryServiceImpl.this.getNode(RepositoryServiceImpl.this.idFactory.createNodeId(nodeId.getUniqueID()), sInfo);
                        relPath = path.isAbsolute() ? RepositoryServiceImpl.this.getPathFactory().getRootPath().computeRelativePath(nodeId.getPath()) : path;
                    } else {
                        for (int degree = 0; degree < path.getLength(); ++degree) {
                            Path ancestorPath = path.getAncestor(degree);
                            NodeId parentId = RepositoryServiceImpl.this.idFactory.createNodeId(nodeId.getUniqueID(), ancestorPath);
                            if (!RepositoryServiceImpl.this.hasNode(sessionInfo, parentId)) continue;
                            n = RepositoryServiceImpl.this.getNode(parentId, sInfo);
                            relPath = ancestorPath.computeRelativePath(path);
                        }
                    }
                    if (n == null) {
                        throw new PathNotFoundException("Path not found " + nodeId);
                    }
                    n.restore(v, sInfo.getNamePathResolver().getJCRPath(relPath), removeExisting);
                }
                return null;
            }
        }, sInfo);
    }

    private boolean hasNode(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            this.getNode(nodeId, sInfo);
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    public void restore(SessionInfo sessionInfo, final NodeId[] versionIds, final boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Version[] versions = new Version[versionIds.length];
                for (int i = 0; i < versions.length; ++i) {
                    Node n = RepositoryServiceImpl.this.getNode(versionIds[i], sInfo);
                    if (!(n instanceof Version)) {
                        throw new RepositoryException(n.getPath() + " does not reference a Version node");
                    }
                    versions[i] = (Version)n;
                }
                sInfo.getSession().getWorkspace().restore(versions, removeExisting);
                return null;
            }
        }, sInfo);
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, final NodeId nodeId, final String srcWorkspaceName, final boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (Iterator)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String nodePath = RepositoryServiceImpl.this.getNodePath(nodeId, sInfo);
                NodeIterator it = RepositoryServiceImpl.this.getVersionManager(sInfo).merge(nodePath, srcWorkspaceName, bestEffort);
                ArrayList<NodeId> ids = new ArrayList<NodeId>();
                while (it.hasNext()) {
                    ids.add(RepositoryServiceImpl.this.idFactory.createNodeId(it.nextNode()));
                }
                return ids.iterator();
            }
        }, sInfo);
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, final NodeId nodeId, final String srcWorkspaceName, final boolean bestEffort, final boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (Iterator)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String nodePath = RepositoryServiceImpl.this.getNodePath(nodeId, sInfo);
                NodeIterator it = RepositoryServiceImpl.this.getVersionManager(sInfo).merge(nodePath, srcWorkspaceName, bestEffort, isShallow);
                ArrayList<NodeId> ids = new ArrayList<NodeId>();
                while (it.hasNext()) {
                    ids.add(RepositoryServiceImpl.this.idFactory.createNodeId(it.nextNode()));
                }
                return ids.iterator();
            }
        }, sInfo);
    }

    public void resolveMergeConflict(SessionInfo sessionInfo, final NodeId nodeId, final NodeId[] mergeFailedIds, final NodeId[] predecessorIds) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node node = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                Version version = null;
                NamePathResolver resolver = sInfo.getNamePathResolver();
                List<NodeId> l = Arrays.asList(mergeFailedIds);
                Property mergeFailed = node.getProperty(resolver.getJCRName(NameConstants.JCR_MERGEFAILED));
                for (Value value : mergeFailed.getValues()) {
                    String uuid = value.getString();
                    if (l.contains(RepositoryServiceImpl.this.idFactory.createNodeId(uuid))) continue;
                    version = (Version)sInfo.getSession().getNodeByIdentifier(uuid);
                    break;
                }
                l = new ArrayList<NodeId>(predecessorIds.length);
                l.addAll(Arrays.asList(predecessorIds));
                Property predecessors = node.getProperty(resolver.getJCRName(NameConstants.JCR_PREDECESSORS));
                for (Value value : predecessors.getValues()) {
                    NodeId vId = RepositoryServiceImpl.this.idFactory.createNodeId(value.getString());
                    l.remove(vId);
                }
                boolean cancel = l.isEmpty();
                if (cancel) {
                    node.cancelMerge(version);
                } else {
                    node.doneMerge(version);
                }
                return null;
            }
        }, sInfo);
    }

    public void addVersionLabel(SessionInfo sessionInfo, final NodeId versionHistoryId, final NodeId versionId, final Name label, final boolean moveLabel) throws VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String jcrLabel = sInfo.getNamePathResolver().getJCRName(label);
                Node version = RepositoryServiceImpl.this.getNode(versionId, sInfo);
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistory node");
                }
                ((VersionHistory)vHistory).addVersionLabel(version.getName(), jcrLabel, moveLabel);
                return null;
            }
        }, sInfo);
    }

    public void removeVersionLabel(SessionInfo sessionInfo, final NodeId versionHistoryId, NodeId versionId, final Name label) throws VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String jcrLabel = sInfo.getNamePathResolver().getJCRName(label);
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistory node");
                }
                ((VersionHistory)vHistory).removeVersionLabel(jcrLabel);
                return null;
            }
        }, sInfo);
    }

    public NodeId createActivity(SessionInfo sessionInfo, final String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        final VersionManager vMgr = this.getVersionManager(sInfo);
        Node activity = (Node)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                return vMgr.createActivity(title);
            }
        }, this.getSessionInfoImpl(sessionInfo));
        return this.idFactory.createNodeId(activity);
    }

    public void removeActivity(SessionInfo sessionInfo, final NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        final VersionManager vMgr = this.getVersionManager(sInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                vMgr.removeActivity(RepositoryServiceImpl.this.getNode(activityId, sInfo));
                return null;
            }
        }, this.getSessionInfoImpl(sessionInfo));
    }

    public Iterator<NodeId> mergeActivity(SessionInfo sessionInfo, final NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (Iterator)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node node = RepositoryServiceImpl.this.getNode(activityId, sInfo);
                NodeIterator it = RepositoryServiceImpl.this.getVersionManager(sInfo).merge(node);
                ArrayList<NodeId> ids = new ArrayList<NodeId>();
                while (it.hasNext()) {
                    ids.add(RepositoryServiceImpl.this.idFactory.createNodeId(it.nextNode()));
                }
                return ids.iterator();
            }
        }, sInfo);
    }

    public NodeId createConfiguration(SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        final VersionManager vMgr = this.getVersionManager(sInfo);
        Node configuration = (Node)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                return vMgr.createConfiguration(RepositoryServiceImpl.this.getNodePath(nodeId, sInfo));
            }
        }, this.getSessionInfoImpl(sessionInfo));
        return this.idFactory.createNodeId(configuration);
    }

    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getQueryManager().getSupportedQueryLanguages();
    }

    public String[] checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces) throws InvalidQueryException, RepositoryException {
        Query q = this.createQuery(this.getSessionInfoImpl(sessionInfo).getSession(), statement, language, namespaces);
        return q.getBindVariableNames();
    }

    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> values) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Query query = this.createQuery(sInfo.getSession(), statement, language, namespaces);
        if (limit != -1L) {
            query.setLimit(limit);
        }
        if (offset != -1L) {
            query.setOffset(offset);
        }
        if (values != null && !values.isEmpty()) {
            for (Map.Entry<String, QValue> entry : values.entrySet()) {
                Value value = ValueFormat.getJCRValue((QValue)entry.getValue(), (NamePathResolver)sInfo.getNamePathResolver(), (ValueFactory)sInfo.getSession().getValueFactory());
                query.bindValue(entry.getKey(), value);
            }
        }
        return new QueryInfoImpl(query.execute(), this.idFactory, sInfo.getNamePathResolver(), this.getQValueFactory());
    }

    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuid, Name[] nodeTypeName, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<Name> ntNames = null;
        if (nodeTypeName != null) {
            ntNames = new HashSet<Name>(Arrays.asList(nodeTypeName));
        }
        return new EventFilterImpl(eventTypes, absPath, isDeep, uuid, ntNames, noLocal);
    }

    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getSessionInfoImpl(sessionInfo).createSubscription((IdFactory)this.idFactory, this.qValueFactory, filters);
    }

    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, UnsupportedRepositoryOperationException, InterruptedException {
        if (subscription instanceof EventSubscription) {
            return ((EventSubscription)subscription).getEventBundles(timeout);
        }
        throw new RepositoryException("Unknown subscription implementation: " + subscription.getClass().getName());
    }

    public EventBundle getEvents(SessionInfo sessionInfo, EventFilter filter, long after) throws RepositoryException, UnsupportedRepositoryOperationException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        EventJournal journal = sInfo.getSession().getWorkspace().getObservationManager().getEventJournal();
        if (journal == null) {
            throw new UnsupportedRepositoryOperationException();
        }
        EventFactory factory = new EventFactory(sInfo.getSession(), sInfo.getNamePathResolver(), (IdFactory)this.idFactory, this.qValueFactory);
        journal.skipTo(after);
        ArrayList<Event> events = new ArrayList<Event>();
        int batchSize = 1024;
        boolean distinctDates = true;
        long lastDate = Long.MIN_VALUE;
        while (journal.hasNext() && (batchSize > 0 || !distinctDates)) {
            Event e = factory.fromJCREvent(journal.nextEvent());
            if (!filter.accept(e, false)) continue;
            distinctDates = lastDate != e.getDate();
            lastDate = e.getDate();
            events.add(e);
            --batchSize;
        }
        return new EventBundleImpl(events, false);
    }

    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        this.getEventSubscription(subscription).setFilters(filters);
    }

    public void dispose(Subscription subscription) throws RepositoryException {
        this.getEventSubscription(subscription).dispose();
    }

    public Map<String, String> getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NamespaceRegistry nsReg = sInfo.getSession().getWorkspace().getNamespaceRegistry();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (String prefix : nsReg.getPrefixes()) {
            namespaces.put(prefix, nsReg.getURI(prefix));
        }
        return namespaces;
    }

    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws NamespaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws NamespaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getNamespaceRegistry().getPrefix(uri);
    }

    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        Session session = this.getSessionInfoImpl(sessionInfo).getSession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        nsReg.registerNamespace(prefix, uri);
    }

    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        Session session = this.getSessionInfoImpl(sessionInfo).getSession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        nsReg.unregisterNamespace(nsReg.getPrefix(uri));
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<QNodeTypeDefinitionImpl> nodeTypes = new ArrayList<QNodeTypeDefinitionImpl>();
        try {
            NodeTypeIterator it = ntMgr.getAllNodeTypes();
            while (it.hasNext()) {
                NodeType nt = it.nextNodeType();
                nodeTypes.add(new QNodeTypeDefinitionImpl((NodeTypeDefinition)nt, sInfo.getNamePathResolver(), this.getQValueFactory()));
            }
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        return nodeTypes.iterator();
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<QNodeTypeDefinitionImpl> defs = new ArrayList<QNodeTypeDefinitionImpl>();
        for (Name nodetypeName : nodetypeNames) {
            try {
                NodeType[] supertypes;
                String ntName = sInfo.getNamePathResolver().getJCRName(nodetypeName);
                NodeType nt = ntMgr.getNodeType(ntName);
                defs.add(new QNodeTypeDefinitionImpl((NodeTypeDefinition)nt, sInfo.getNamePathResolver(), this.getQValueFactory()));
                for (NodeType supertype : supertypes = nt.getSupertypes()) {
                    defs.add(new QNodeTypeDefinitionImpl((NodeTypeDefinition)supertype, sInfo.getNamePathResolver(), this.getQValueFactory()));
                }
            }
            catch (NameException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return defs.iterator();
    }

    public void registerNodeTypes(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        NodeTypeDefinition[] defs = new NodeTypeDefinition[nodeTypeDefinitions.length];
        for (int i = 0; i < nodeTypeDefinitions.length; ++i) {
            defs[i] = new NodeTypeDefinitionImpl(nodeTypeDefinitions[i], sInfo.getNamePathResolver(), sInfo.getSession().getValueFactory()){};
        }
        ntMgr.registerNodeTypes(defs, allowUpdate);
    }

    public void unregisterNodeTypes(SessionInfo sessionInfo, Name[] nodeTypeNames) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        String[] names = new String[nodeTypeNames.length];
        for (int i = 0; i < nodeTypeNames.length; ++i) {
            names[i] = sInfo.getNamePathResolver().getJCRName(nodeTypeNames[i]);
        }
        ntMgr.unregisterNodeTypes(names);
    }

    public void createWorkspace(SessionInfo sessionInfo, String name, String srcWorkspaceName) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Workspace wsp = sInfo.getSession().getWorkspace();
        if (srcWorkspaceName == null) {
            wsp.createWorkspace(name);
        } else {
            wsp.createWorkspace(name, srcWorkspaceName);
        }
    }

    public void deleteWorkspace(SessionInfo sessionInfo, String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Workspace wsp = sInfo.getSession().getWorkspace();
        wsp.deleteWorkspace(name);
    }

    private SessionInfoImpl getSessionInfoImpl(SessionInfo sessionInfo) throws RepositoryException {
        if (sessionInfo instanceof SessionInfoImpl) {
            return (SessionInfoImpl)sessionInfo;
        }
        throw new RepositoryException("Unknown SessionInfo implementation: " + sessionInfo.getClass().getName());
    }

    private EventSubscription getEventSubscription(Subscription subscription) throws RepositoryException {
        if (subscription instanceof EventSubscription) {
            return (EventSubscription)subscription;
        }
        throw new RepositoryException("Unknown Subscription implementation: " + subscription.getClass().getName());
    }

    private String getDestinationPath(NodeId destParentNodeId, Name destName, SessionInfoImpl sessionInfo) throws RepositoryException {
        StringBuffer destPath = new StringBuffer(this.pathForId((ItemId)destParentNodeId, sessionInfo));
        if (destPath.length() > 1) {
            destPath.append("/");
        }
        destPath.append(sessionInfo.getNamePathResolver().getJCRName(destName));
        return destPath.toString();
    }

    private String pathForId(ItemId id, SessionInfoImpl sessionInfo) throws RepositoryException {
        Session session = sessionInfo.getSession();
        StringBuffer path = new StringBuffer();
        if (id.getUniqueID() != null) {
            path.append(session.getNodeByIdentifier(id.getUniqueID()).getPath());
        } else {
            path.append("/");
        }
        if (id.getPath() == null) {
            return path.toString();
        }
        if (id.getPath().isAbsolute()) {
            if (path.length() == 1) {
                path.setLength(0);
            }
        } else if (path.length() > 1) {
            path.append("/");
        }
        path.append(sessionInfo.getNamePathResolver().getJCRPath(id.getPath()));
        return path.toString();
    }

    private Node getParent(NodeId parentId, SessionInfoImpl sessionInfo) throws InvalidItemStateException, RepositoryException {
        try {
            return this.getNode(parentId, sessionInfo);
        }
        catch (PathNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
    }

    private Node getNode(NodeId id, SessionInfoImpl sessionInfo) throws ItemNotFoundException, PathNotFoundException, RepositoryException {
        Session session = sessionInfo.getSession();
        Node n = id.getUniqueID() != null ? session.getNodeByIdentifier(id.getUniqueID()) : session.getRootNode();
        Path path = id.getPath();
        if (path == null || path.denotesRoot()) {
            return n;
        }
        String jcrPath = sessionInfo.getNamePathResolver().getJCRPath(path);
        if (path.isAbsolute()) {
            jcrPath = jcrPath.substring(1, jcrPath.length());
        }
        return n.getNode(jcrPath);
    }

    private String getNodePath(NodeId nodeId, SessionInfoImpl sessionInfo) throws RepositoryException {
        return this.getNode(nodeId, sessionInfo).getPath();
    }

    private Property getProperty(PropertyId id, SessionInfoImpl sessionInfo) throws ItemNotFoundException, PathNotFoundException, RepositoryException {
        Session session = sessionInfo.getSession();
        Node n = id.getUniqueID() != null ? session.getNodeByIdentifier(id.getUniqueID()) : session.getRootNode();
        Path path = id.getPath();
        String jcrPath = sessionInfo.getNamePathResolver().getJCRPath(path);
        if (path.isAbsolute()) {
            jcrPath = jcrPath.substring(1, jcrPath.length());
        }
        return n.getProperty(jcrPath);
    }

    private VersionManager getVersionManager(SessionInfoImpl sessionInfo) throws RepositoryException {
        return sessionInfo.getSession().getWorkspace().getVersionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query createQuery(Session session, String statement, String language, Map<String, String> namespaces) throws InvalidQueryException, RepositoryException {
        QueryManager qMgr = session.getWorkspace().getQueryManager();
        Map<String, String> previous = this.setNamespaceMappings(session, namespaces);
        try {
            Query query = qMgr.createQuery(statement, language);
            return query;
        }
        finally {
            this.setNamespaceMappings(session, previous);
        }
    }

    private Map<String, String> setNamespaceMappings(Session session, Map<String, String> namespaces) throws RepositoryException {
        HashMap<String, String> previous = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            String oldPrefix;
            String uri = entry.getValue();
            String prefix = entry.getKey();
            if (prefix.equals(oldPrefix = session.getNamespacePrefix(uri))) continue;
            String oldURI = this.safeGetURI(session, prefix);
            if (oldURI != null) {
                int i = 2;
                String tmpPrefix = oldPrefix + i++;
                while (this.safeGetURI(session, tmpPrefix) != null || namespaces.containsKey(tmpPrefix)) {
                    tmpPrefix = oldPrefix + i++;
                }
                session.setNamespacePrefix(tmpPrefix, oldURI);
                previous.put(prefix, oldURI);
            }
            session.setNamespacePrefix(prefix, uri);
            previous.put(oldPrefix, uri);
        }
        return previous;
    }

    private String safeGetURI(Session session, String prefix) throws RepositoryException {
        try {
            return session.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeWithLocalEvents(Callable call, SessionInfoImpl sInfo) throws RepositoryException {
        Collection<EventSubscription> subscr;
        if (this.supportsObservation && (subscr = sInfo.getSubscriptions()).size() != 0) {
            ObservationManager obsMgr = sInfo.getSession().getWorkspace().getObservationManager();
            ArrayList<EventListener> listeners = new ArrayList<EventListener>(subscr.size());
            try {
                for (EventSubscription s : subscr) {
                    EventListener listener = s.getLocalEventListener();
                    listeners.add(listener);
                    obsMgr.addEventListener(listener, 127, "/", true, null, null, false);
                }
                Object object = call.run();
                return object;
            }
            finally {
                for (EventListener listener : listeners) {
                    try {
                        obsMgr.removeEventListener(listener);
                    }
                    catch (RepositoryException e) {}
                }
            }
        }
        return call.run();
    }

    private static interface Callable {
        public Object run() throws RepositoryException;
    }

    private final class BatchImpl
    implements Batch {
        private final SessionInfoImpl sInfo;
        private final Set<NodeId> removedNodeIds = new HashSet<NodeId>();
        private boolean failed = false;

        BatchImpl(SessionInfoImpl sInfo) {
            this.sInfo = sInfo;
        }

        public void addNode(final NodeId parentId, final Name nodeName, final Name nodetypeName, final String uuid) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.this.sInfo.getSession();
                    Node parent = RepositoryServiceImpl.this.getParent(parentId, BatchImpl.this.sInfo);
                    String jcrName = BatchImpl.this.getJcrName(nodeName);
                    String ntName = BatchImpl.this.getJcrName(nodetypeName);
                    if (uuid == null) {
                        if (ntName == null) {
                            parent.addNode(jcrName);
                        } else {
                            parent.addNode(jcrName, ntName);
                        }
                    } else {
                        String xml = BatchImpl.this.createXMLFragment(jcrName, ntName, uuid);
                        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                        try {
                            s.importXML(parent.getPath(), (InputStream)in, 3);
                        }
                        catch (IOException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }

        public void addProperty(final NodeId parentId, final Name propertyName, final QValue value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.this.sInfo.getSession();
                    Node parent = RepositoryServiceImpl.this.getParent(parentId, BatchImpl.this.sInfo);
                    Value jcrValue = ValueFormat.getJCRValue((QValue)value, (NamePathResolver)BatchImpl.this.sInfo.getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    parent.setProperty(BatchImpl.this.getJcrName(propertyName), jcrValue);
                    return null;
                }
            });
        }

        public void addProperty(final NodeId parentId, final Name propertyName, final QValue[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.this.sInfo.getSession();
                    Node n = RepositoryServiceImpl.this.getParent(parentId, BatchImpl.this.sInfo);
                    Value[] jcrValues = new Value[values.length];
                    for (int i = 0; i < jcrValues.length; ++i) {
                        jcrValues[i] = ValueFormat.getJCRValue((QValue)values[i], (NamePathResolver)BatchImpl.this.sInfo.getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    }
                    n.setProperty(BatchImpl.this.getJcrName(propertyName), jcrValues);
                    return null;
                }
            });
        }

        public void setValue(final PropertyId propertyId, final QValue value) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.this.sInfo.getSession();
                    Value jcrValue = ValueFormat.getJCRValue((QValue)value, (NamePathResolver)BatchImpl.this.sInfo.getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    RepositoryServiceImpl.this.getProperty(propertyId, BatchImpl.this.sInfo).setValue(jcrValue);
                    return null;
                }
            });
        }

        public void setValue(final PropertyId propertyId, final QValue[] values) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.this.sInfo.getSession();
                    Value[] jcrValues = new Value[values.length];
                    for (int i = 0; i < jcrValues.length; ++i) {
                        jcrValues[i] = ValueFormat.getJCRValue((QValue)values[i], (NamePathResolver)BatchImpl.this.sInfo.getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    }
                    RepositoryServiceImpl.this.getProperty(propertyId, BatchImpl.this.sInfo).setValue(jcrValues);
                    return null;
                }
            });
        }

        public void remove(final ItemId itemId) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    try {
                        if (itemId.denotesNode()) {
                            NodeId nodeId = BatchImpl.this.calcRemoveNodeId(itemId);
                            RepositoryServiceImpl.this.getNode(nodeId, BatchImpl.this.sInfo).remove();
                        } else {
                            RepositoryServiceImpl.this.getProperty((PropertyId)itemId, BatchImpl.this.sInfo).remove();
                        }
                    }
                    catch (ItemNotFoundException e) {
                        throw new InvalidItemStateException((Throwable)e);
                    }
                    catch (PathNotFoundException e) {
                        throw new InvalidItemStateException((Throwable)e);
                    }
                    return null;
                }
            });
        }

        private NodeId calcRemoveNodeId(ItemId itemId) throws MalformedPathException {
            NodeId nodeId = (NodeId)itemId;
            Path p = itemId.getPath();
            if (p != null) {
                this.removedNodeIds.add(nodeId);
                int index = p.getNormalizedIndex();
                if (index > 1) {
                    Path.Element[] elems = p.getElements();
                    PathBuilder pb = new PathBuilder();
                    for (int i = 0; i <= elems.length - 2; ++i) {
                        pb.addLast(elems[i]);
                    }
                    pb.addLast(p.getName(), index - 1);
                    NodeId prevSibling = RepositoryServiceImpl.this.idFactory.createNodeId(itemId.getUniqueID(), pb.getPath());
                    if (this.removedNodeIds.contains(prevSibling)) {
                        nodeId = prevSibling;
                    }
                }
            }
            return nodeId;
        }

        public void reorderNodes(final NodeId parentId, final NodeId srcNodeId, final NodeId beforeNodeId) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Node parent = RepositoryServiceImpl.this.getParent(parentId, BatchImpl.this.sInfo);
                    Node srcNode = RepositoryServiceImpl.this.getNode(srcNodeId, BatchImpl.this.sInfo);
                    Node beforeNode = null;
                    if (beforeNodeId != null) {
                        beforeNode = RepositoryServiceImpl.this.getNode(beforeNodeId, BatchImpl.this.sInfo);
                    }
                    String srcPath = srcNode.getName();
                    if (srcNode.getIndex() > 1) {
                        srcPath = srcPath + "[" + srcNode.getIndex() + "]";
                    }
                    String beforePath = null;
                    if (beforeNode != null) {
                        beforePath = beforeNode.getName();
                        if (beforeNode.getIndex() > 1) {
                            beforePath = beforePath + "[" + beforeNode.getIndex() + "]";
                        }
                    }
                    parent.orderBefore(srcPath, beforePath);
                    return null;
                }
            });
        }

        public void setMixins(final NodeId nodeId, final Name[] mixinNodeTypeIds) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    HashSet<String> mixinNames = new HashSet<String>();
                    for (Name mixinNodeTypeId : mixinNodeTypeIds) {
                        mixinNames.add(BatchImpl.this.getJcrName(mixinNodeTypeId));
                    }
                    Node n = RepositoryServiceImpl.this.getNode(nodeId, BatchImpl.this.sInfo);
                    HashSet<String> currentMixins = new HashSet<String>();
                    for (NodeType nt : n.getMixinNodeTypes()) {
                        currentMixins.add(nt.getName());
                    }
                    HashSet remove = new HashSet(currentMixins);
                    remove.removeAll(mixinNames);
                    mixinNames.removeAll(currentMixins);
                    for (String mixName : remove) {
                        n.removeMixin(mixName);
                    }
                    for (String mixName : mixinNames) {
                        n.addMixin(mixName);
                    }
                    return null;
                }
            });
        }

        public void setPrimaryType(final NodeId nodeId, final Name primaryNodeTypeName) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    Node n = RepositoryServiceImpl.this.getNode(nodeId, BatchImpl.this.sInfo);
                    n.setPrimaryType(BatchImpl.this.getJcrName(primaryNodeTypeName));
                    return null;
                }
            });
        }

        public void move(final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName) throws RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, BatchImpl.this.sInfo);
                    String destPath = RepositoryServiceImpl.this.pathForId((ItemId)destParentNodeId, BatchImpl.this.sInfo);
                    if (destPath.length() > 1) {
                        destPath = destPath + "/";
                    }
                    destPath = destPath + BatchImpl.this.getJcrName(destName);
                    BatchImpl.this.sInfo.getSession().move(srcPath, destPath);
                    return null;
                }
            });
        }

        private void executeGuarded(Callable call) throws RepositoryException {
            if (this.failed) {
                return;
            }
            try {
                call.run();
            }
            catch (RepositoryException e) {
                this.failed = true;
                this.sInfo.getSession().refresh(false);
                throw e;
            }
            catch (RuntimeException e) {
                this.failed = true;
                this.sInfo.getSession().refresh(false);
                throw e;
            }
        }

        private String getJcrName(Name name) throws RepositoryException {
            if (name == null) {
                return null;
            }
            return this.sInfo.getNamePathResolver().getJCRName(name);
        }

        private String createXMLFragment(String nodeName, String ntName, String uuid) {
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.append("<sv:node xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" ");
            xml.append("xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" ");
            xml.append("sv:name=\"").append(nodeName).append("\">");
            xml.append("<sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">");
            xml.append("<sv:value>").append(ntName).append("</sv:value>");
            xml.append("</sv:property>");
            xml.append("<sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">");
            xml.append("<sv:value>").append(uuid).append("</sv:value>");
            xml.append("</sv:property>");
            xml.append("</sv:node>");
            return xml.toString();
        }

        private void end() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
            this.executeGuarded(new Callable(){

                public Object run() throws RepositoryException {
                    RepositoryServiceImpl.this.executeWithLocalEvents(new Callable(){

                        public Object run() throws RepositoryException {
                            BatchImpl.this.sInfo.getSession().save();
                            return null;
                        }
                    }, BatchImpl.this.sInfo);
                    return null;
                }
            });
        }
    }
}

